/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnectorId;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.util.Types;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;

public class JmxSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final NodeManager nodeManager;

    @Inject
    public JmxSplitManager(JmxConnectorId jmxConnectorId, NodeManager nodeManager) {
        this.connectorId = ((JmxConnectorId)Preconditions.checkNotNull((Object)jmxConnectorId, (Object)"jmxConnectorId is null")).toString();
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle table, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
        JmxTableHandle jmxTableHandle = Types.checkType(table, JmxTableHandle.class, "table");
        ImmutableList partitions = ImmutableList.of((Object)new JmxPartition(jmxTableHandle));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle table, List<ConnectorPartition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource(this.connectorId, (Iterable)ImmutableList.of());
        }
        ConnectorPartition partition = (ConnectorPartition)Iterables.getOnlyElement(partitions);
        JmxTableHandle tableHandle = Types.checkType(partition, JmxPartition.class, "partition").getTableHandle();
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : this.nodeManager.getActiveNodes()) {
            splits.add((Object)new JmxSplit(tableHandle, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort())));
        }
        return new FixedSplitSource(this.connectorId, (Iterable)splits.build());
    }

    public static class JmxPartition
    implements ConnectorPartition {
        private final JmxTableHandle tableHandle;

        public JmxPartition(JmxTableHandle tableHandle) {
            this.tableHandle = (JmxTableHandle)Preconditions.checkNotNull((Object)tableHandle, (Object)"tableHandle is null");
        }

        public JmxTableHandle getTableHandle() {
            return this.tableHandle;
        }

        public String getPartitionId() {
            return "jmx";
        }

        public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
            return TupleDomain.all();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("tableHandle", (Object)this.tableHandle).toString();
        }
    }
}

