/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Types;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;

public class InformationSchemaMetadata
extends ReadOnlyConnectorMetadata {
    public static final String INFORMATION_SCHEMA = "information_schema";
    public static final SchemaTableName TABLE_COLUMNS = new SchemaTableName("information_schema", "columns");
    public static final SchemaTableName TABLE_TABLES = new SchemaTableName("information_schema", "tables");
    public static final SchemaTableName TABLE_VIEWS = new SchemaTableName("information_schema", "views");
    public static final SchemaTableName TABLE_SCHEMATA = new SchemaTableName("information_schema", "schemata");
    public static final SchemaTableName TABLE_INTERNAL_FUNCTIONS = new SchemaTableName("information_schema", "__internal_functions__");
    public static final SchemaTableName TABLE_INTERNAL_PARTITIONS = new SchemaTableName("information_schema", "__internal_partitions__");
    public static final Map<SchemaTableName, ConnectorTableMetadata> TABLES = MetadataUtil.SchemaMetadataBuilder.schemaMetadataBuilder().table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_COLUMNS).column("table_catalog", (Type)VarcharType.VARCHAR).column("table_schema", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("column_name", (Type)VarcharType.VARCHAR).column("ordinal_position", (Type)BigintType.BIGINT).column("column_default", (Type)VarcharType.VARCHAR).column("is_nullable", (Type)VarcharType.VARCHAR).column("data_type", (Type)VarcharType.VARCHAR).column("is_partition_key", (Type)VarcharType.VARCHAR).column("comment", (Type)VarcharType.VARCHAR).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_TABLES).column("table_catalog", (Type)VarcharType.VARCHAR).column("table_schema", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("table_type", (Type)VarcharType.VARCHAR).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_VIEWS).column("table_catalog", (Type)VarcharType.VARCHAR).column("table_schema", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("view_definition", (Type)VarcharType.VARCHAR).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_SCHEMATA).column("catalog_name", (Type)VarcharType.VARCHAR).column("schema_name", (Type)VarcharType.VARCHAR).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_INTERNAL_FUNCTIONS).column("function_name", (Type)VarcharType.VARCHAR).column("argument_types", (Type)VarcharType.VARCHAR).column("return_type", (Type)VarcharType.VARCHAR).column("function_type", (Type)VarcharType.VARCHAR).column("description", (Type)VarcharType.VARCHAR).build()).table(MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(TABLE_INTERNAL_PARTITIONS).column("table_catalog", (Type)VarcharType.VARCHAR).column("table_schema", (Type)VarcharType.VARCHAR).column("table_name", (Type)VarcharType.VARCHAR).column("partition_number", (Type)BigintType.BIGINT).column("partition_key", (Type)VarcharType.VARCHAR).column("partition_value", (Type)VarcharType.VARCHAR).build()).build();
    private final String catalogName;

    public InformationSchemaMetadata(String catalogName) {
        this.catalogName = catalogName;
    }

    private InformationSchemaTableHandle checkTableHandle(ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle handle = Types.checkType(tableHandle, InformationSchemaTableHandle.class, "tableHandle");
        Preconditions.checkArgument((boolean)handle.getCatalogName().equals(this.catalogName), (String)"invalid table handle: expected catalog %s but got %s", (Object[])new Object[]{this.catalogName, handle.getCatalogName()});
        Preconditions.checkArgument((boolean)TABLES.containsKey(handle.getSchemaTableName()), (String)"table %s does not exist", (Object[])new Object[]{handle.getSchemaTableName()});
        return handle;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)INFORMATION_SCHEMA);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!TABLES.containsKey(tableName)) {
            return null;
        }
        return new InformationSchemaTableHandle(session, this.catalogName, tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        return TABLES.get(informationSchemaTableHandle.getSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return ImmutableList.copyOf(TABLES.keySet());
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(TABLES.keySet(), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)schemaNameOrNull), MetadataUtil.schemaNameGetter())));
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        String columnName;
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = Types.checkType(columnHandle, InformationSchemaColumnHandle.class, "columnHandle").getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column %s on table %s does not exist", (Object[])new Object[]{columnName, tableMetadata.getTable()});
        return columnMetadata;
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = this.checkTableHandle(tableHandle);
        ConnectorTableMetadata tableMetadata = TABLES.get(informationSchemaTableHandle.getSchemaTableName());
        return InformationSchemaColumnHandle.toInformationSchemaColumnHandles(tableMetadata);
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, ConnectorTableMetadata> entry : TABLES.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)entry.getValue().getColumns());
        }
        return builder.build();
    }

    static List<ColumnMetadata> informationSchemaTableColumns(SchemaTableName tableName) {
        Preconditions.checkArgument((boolean)TABLES.containsKey(tableName), (String)"table does not exist: %s", (Object[])new Object[]{tableName});
        return TABLES.get(tableName).getColumns();
    }
}

