/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.InternalTable;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.metadata.Partition;
import com.facebook.presto.metadata.PartitionResult;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.QualifiedTablePrefix;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.operator.AlignmentOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.util.Types;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public class InformationSchemaDataStreamProvider
implements ConnectorDataStreamProvider {
    private final Metadata metadata;
    private final SplitManager splitManager;

    @Inject
    public InformationSchemaDataStreamProvider(Metadata metadata, SplitManager splitManager) {
        this.metadata = (Metadata)Preconditions.checkNotNull((Object)metadata, (Object)"metadata is null");
        this.splitManager = (SplitManager)Preconditions.checkNotNull((Object)splitManager, (Object)"splitManager is null");
    }

    @Override
    public Operator createNewDataStream(OperatorContext operatorContext, ConnectorSplit split, List<ConnectorColumnHandle> columns) {
        InternalTable table = this.getInternalTable(split, columns);
        ImmutableList.Builder types = ImmutableList.builder();
        ImmutableList.Builder channels = ImmutableList.builder();
        for (ConnectorColumnHandle column : columns) {
            String columnName = Types.checkType(column, InformationSchemaColumnHandle.class, "column").getColumnName();
            types.add((Object)table.getType(columnName));
            channels.add(table.getColumn(columnName));
        }
        return new AlignmentOperator(operatorContext, (List<Type>)types.build(), (Iterable<Iterable<Block>>)channels.build());
    }

    private InternalTable getInternalTable(ConnectorSplit connectorSplit, List<ConnectorColumnHandle> columns) {
        InformationSchemaSplit split = Types.checkType(connectorSplit, InformationSchemaSplit.class, "split");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        InformationSchemaTableHandle handle = split.getTableHandle();
        Map<String, Object> filters = split.getFilters();
        return this.getInformationSchemaTable(handle.getSession(), handle.getCatalogName(), handle.getSchemaTableName(), filters);
    }

    public InternalTable getInformationSchemaTable(ConnectorSession session, String catalog, SchemaTableName table, Map<String, Object> filters) {
        if (table.equals((Object)InformationSchemaMetadata.TABLE_COLUMNS)) {
            return this.buildColumns(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_TABLES)) {
            return this.buildTables(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_VIEWS)) {
            return this.buildViews(session, catalog, filters);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_SCHEMATA)) {
            return this.buildSchemata(session, catalog);
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS)) {
            return this.buildFunctions();
        }
        if (table.equals((Object)InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS)) {
            return this.buildPartitions(session, catalog, filters);
        }
        throw new IllegalArgumentException(String.format("table does not exist: %s", table));
    }

    private InternalTable buildColumns(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_COLUMNS));
        for (Map.Entry<QualifiedTableName, List<ColumnMetadata>> entry : this.getColumnsList(session, catalogName, filters).entrySet()) {
            QualifiedTableName tableName = entry.getKey();
            for (ColumnMetadata column : entry.getValue()) {
                if (column.isHidden()) continue;
                table.add(tableName.getCatalogName(), tableName.getSchemaName(), tableName.getTableName(), column.getName(), column.getOrdinalPosition() + 1, null, "YES", column.getType().getName(), column.isPartitionKey() ? "YES" : "NO", column.getComment());
            }
        }
        return table.build();
    }

    private Map<QualifiedTableName, List<ColumnMetadata>> getColumnsList(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        return this.metadata.listTableColumns(session, InformationSchemaDataStreamProvider.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildTables(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        ImmutableSet tables = ImmutableSet.copyOf(this.getTablesList(session, catalogName, filters));
        ImmutableSet views = ImmutableSet.copyOf(this.getViewsList(session, catalogName, filters));
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_TABLES));
        for (QualifiedTableName name : Sets.union((Set)tables, (Set)views)) {
            String type = views.contains(name) ? "VIEW" : "BASE TABLE";
            table.add(name.getCatalogName(), name.getSchemaName(), name.getTableName(), type);
        }
        return table.build();
    }

    private List<QualifiedTableName> getTablesList(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        return this.metadata.listTables(session, InformationSchemaDataStreamProvider.extractQualifiedTablePrefix(catalogName, filters));
    }

    private List<QualifiedTableName> getViewsList(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        return this.metadata.listViews(session, InformationSchemaDataStreamProvider.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildViews(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_VIEWS));
        for (Map.Entry<QualifiedTableName, ViewDefinition> entry : this.getViews(session, catalogName, filters).entrySet()) {
            table.add(entry.getKey().getCatalogName(), entry.getKey().getSchemaName(), entry.getKey().getTableName(), entry.getValue().getOriginalSql());
        }
        return table.build();
    }

    private Map<QualifiedTableName, ViewDefinition> getViews(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        return this.metadata.getViews(session, InformationSchemaDataStreamProvider.extractQualifiedTablePrefix(catalogName, filters));
    }

    private InternalTable buildFunctions() {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_INTERNAL_FUNCTIONS));
        for (ParametricFunction function : this.metadata.listFunctions()) {
            if (function.isApproximate()) continue;
            String functionType = function.isAggregate() ? "aggregate" : (function.isWindow() ? "window" : (function.isDeterministic() ? "scalar" : "scalar (non-deterministic)"));
            table.add(function.getSignature().getName(), Joiner.on((String)", ").join(function.getSignature().getArgumentTypes()), function.getSignature().getReturnType(), functionType, Strings.nullToEmpty((String)function.getDescription()));
        }
        return table.build();
    }

    private InternalTable buildSchemata(ConnectorSession session, String catalogName) {
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_SCHEMATA));
        for (String schema : this.metadata.listSchemaNames(session, catalogName)) {
            table.add(catalogName, schema);
        }
        return table.build();
    }

    private InternalTable buildPartitions(ConnectorSession session, String catalogName, Map<String, Object> filters) {
        QualifiedTableName tableName = InformationSchemaDataStreamProvider.extractQualifiedTableName(catalogName, filters);
        InternalTable.Builder table = InternalTable.builder(InformationSchemaMetadata.informationSchemaTableColumns(InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS));
        int partitionNumber = 1;
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(session, tableName);
        Preconditions.checkArgument((boolean)tableHandle.isPresent(), (String)"Table %s does not exist", (Object[])new Object[]{tableName});
        ImmutableBiMap columnHandles = ImmutableBiMap.copyOf(this.metadata.getColumnHandles((TableHandle)tableHandle.get())).inverse();
        PartitionResult partitionResult = this.splitManager.getPartitions((TableHandle)tableHandle.get(), (Optional<TupleDomain<ColumnHandle>>)Optional.absent());
        for (Partition partition : partitionResult.getPartitions()) {
            for (Map.Entry entry : partition.getTupleDomain().extractFixedValues().entrySet()) {
                ColumnHandle columnHandle = (ColumnHandle)entry.getKey();
                String columnName = (String)columnHandles.get(columnHandle);
                String value = null;
                if (entry.getValue() != null) {
                    ColumnMetadata columnMetadata = this.metadata.getColumnMetadata((TableHandle)tableHandle.get(), columnHandle);
                    try {
                        FunctionInfo operator = this.metadata.getFunctionRegistry().getCoercion(columnMetadata.getType(), (Type)VarcharType.VARCHAR);
                        value = ((Slice)operator.getMethodHandle().invokeWithArguments(entry.getValue())).toStringUtf8();
                    }
                    catch (OperatorNotFoundException e) {
                        value = "<UNREPRESENTABLE VALUE>";
                    }
                    catch (Throwable throwable) {
                        throw Throwables.propagate((Throwable)throwable);
                    }
                }
                table.add(catalogName, tableName.getSchemaName(), tableName.getTableName(), partitionNumber, columnName, value);
            }
            ++partitionNumber;
        }
        return table.build();
    }

    private static QualifiedTableName extractQualifiedTableName(String catalogName, Map<String, Object> filters) {
        Optional<String> schemaName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_schema");
        Preconditions.checkArgument((boolean)schemaName.isPresent(), (String)"filter is required for column: %s.%s", (Object[])new Object[]{InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, "table_schema"});
        Optional<String> tableName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_name");
        Preconditions.checkArgument((boolean)tableName.isPresent(), (String)"filter is required for column: %s.%s", (Object[])new Object[]{InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS, "table_name"});
        return new QualifiedTableName(catalogName, (String)schemaName.get(), (String)tableName.get());
    }

    private static QualifiedTablePrefix extractQualifiedTablePrefix(String catalogName, Map<String, Object> filters) {
        Optional<String> schemaName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_schema");
        Optional<String> tableName = InformationSchemaDataStreamProvider.getFilterColumn(filters, "table_name");
        if (!schemaName.isPresent()) {
            return new QualifiedTablePrefix(catalogName, (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent());
        }
        return new QualifiedTablePrefix(catalogName, schemaName, tableName);
    }

    private static Optional<String> getFilterColumn(Map<String, Object> filters, String columnName) {
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            if (!entry.getKey().equals(columnName)) continue;
            if (entry.getValue() instanceof String) {
                return Optional.of((Object)((String)entry.getValue()));
            }
            if (!(entry.getValue() instanceof Slice)) break;
            return Optional.of((Object)((Slice)entry.getValue()).toStringUtf8());
        }
        return Optional.absent();
    }
}

