/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector;

import com.facebook.presto.connector.InternalConnector;
import com.facebook.presto.connector.informationSchema.InformationSchemaDataStreamProvider;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplitManager;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.RecordSinkManager;
import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.split.ConnectorDataStreamProvider;
import com.facebook.presto.split.DataStreamManager;
import com.facebook.presto.split.RecordSetDataStreamProvider;
import com.facebook.presto.split.SplitManager;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class ConnectorManager {
    public static final String INFORMATION_SCHEMA_CONNECTOR_PREFIX = "$info_schema@";
    private final MetadataManager metadataManager;
    private final SplitManager splitManager;
    private final DataStreamManager dataStreamManager;
    private final IndexManager indexManager;
    private final RecordSinkManager recordSinkManager;
    private final HandleResolver handleResolver;
    private final NodeManager nodeManager;
    private final ConcurrentMap<String, ConnectorFactory> connectorFactories = new ConcurrentHashMap<String, ConnectorFactory>();
    private final ConcurrentMap<String, Connector> connectors = new ConcurrentHashMap<String, Connector>();

    @Inject
    public ConnectorManager(MetadataManager metadataManager, SplitManager splitManager, DataStreamManager dataStreamManager, IndexManager indexManager, RecordSinkManager recordSinkManager, HandleResolver handleResolver, Map<String, ConnectorFactory> connectorFactories, Map<String, Connector> globalConnectors, NodeManager nodeManager) {
        this.metadataManager = metadataManager;
        this.splitManager = splitManager;
        this.dataStreamManager = dataStreamManager;
        this.indexManager = indexManager;
        this.recordSinkManager = recordSinkManager;
        this.handleResolver = handleResolver;
        this.nodeManager = nodeManager;
        this.connectorFactories.putAll(connectorFactories);
        for (Map.Entry<String, Connector> entry : globalConnectors.entrySet()) {
            this.addGlobalConnector(entry.getKey(), entry.getValue());
        }
    }

    public void addConnectorFactory(ConnectorFactory connectorFactory) {
        ConnectorFactory existingConnectorFactory = this.connectorFactories.putIfAbsent(connectorFactory.getName(), connectorFactory);
        Preconditions.checkArgument((existingConnectorFactory == null ? 1 : 0) != 0, (String)"Connector %s is already registered", (Object[])new Object[]{connectorFactory.getName()});
    }

    public synchronized void createConnection(String catalogName, String connectorName, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull((Object)connectorName, (Object)"connectorName is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        ConnectorFactory connectorFactory = (ConnectorFactory)this.connectorFactories.get(connectorName);
        Preconditions.checkArgument((connectorFactory != null ? 1 : 0) != 0, (String)"No factory for connector %s", (Object[])new Object[]{connectorName});
        this.createConnection(catalogName, connectorFactory, properties);
    }

    public synchronized void createConnection(String catalogName, ConnectorFactory connectorFactory, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName is null");
        Preconditions.checkNotNull(properties, (Object)"properties is null");
        Preconditions.checkNotNull((Object)connectorFactory, (Object)"connectorFactory is null");
        String connectorId = catalogName;
        Preconditions.checkState((!this.connectors.containsKey(connectorId) ? 1 : 0) != 0, (String)"A connector %s already exists", (Object[])new Object[]{connectorId});
        Connector connector = connectorFactory.create(connectorId, properties);
        this.connectors.put(connectorId, connector);
        this.addConnector(catalogName, connectorId, connector);
    }

    public void addGlobalConnector(String connectorId, Connector connector) {
        this.addConnector(null, connectorId, connector);
    }

    private void addConnector(@Nullable String catalogName, String connectorId, Connector connector) {
        ConnectorMetadata connectorMetadata = connector.getMetadata();
        Preconditions.checkState((connectorMetadata != null ? 1 : 0) != 0, (String)"Connector %s can not provide metadata", (Object[])new Object[]{connectorId});
        ConnectorSplitManager connectorSplitManager = connector.getSplitManager();
        Preconditions.checkState((connectorSplitManager != null ? 1 : 0) != 0, (String)"Connector %s does not have a split manager", (Object[])new Object[]{connectorId});
        ConnectorDataStreamProvider connectorDataStreamProvider = null;
        if (connector instanceof InternalConnector) {
            try {
                connectorDataStreamProvider = ((InternalConnector)connector).getDataStreamProvider();
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
        }
        if (connectorDataStreamProvider == null) {
            ConnectorRecordSetProvider connectorRecordSetProvider = null;
            try {
                connectorRecordSetProvider = connector.getRecordSetProvider();
            }
            catch (UnsupportedOperationException ignored) {
                // empty catch block
            }
            Preconditions.checkState((connectorRecordSetProvider != null ? 1 : 0) != 0, (String)"Connector %s does not have a data stream provider", (Object[])new Object[]{connectorId});
            connectorDataStreamProvider = new RecordSetDataStreamProvider(connectorRecordSetProvider);
        }
        ConnectorHandleResolver connectorHandleResolver = connector.getHandleResolver();
        Preconditions.checkNotNull((Object)connectorHandleResolver, (String)"Connector %s does not have a handle resolver", (Object[])new Object[]{connectorId});
        ConnectorRecordSinkProvider connectorRecordSinkProvider = null;
        try {
            connectorRecordSinkProvider = connector.getRecordSinkProvider();
            Preconditions.checkNotNull((Object)connectorRecordSinkProvider, (String)"Connector %s returned a null record sink provider", (Object[])new Object[]{connectorId});
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        ConnectorIndexResolver indexResolver = null;
        try {
            indexResolver = connector.getIndexResolver();
            Preconditions.checkNotNull((Object)indexResolver, (String)"Connector %s returned a null index resolver", (Object[])new Object[]{connectorId});
        }
        catch (UnsupportedOperationException ignored) {
            // empty catch block
        }
        if (catalogName != null) {
            this.metadataManager.addConnectorMetadata(connectorId, catalogName, connectorMetadata);
            this.metadataManager.addInformationSchemaMetadata(ConnectorManager.makeInformationSchemaConnectorId(connectorId), catalogName, new InformationSchemaMetadata(catalogName));
            this.splitManager.addConnectorSplitManager(ConnectorManager.makeInformationSchemaConnectorId(connectorId), new InformationSchemaSplitManager(this.nodeManager));
            this.dataStreamManager.addConnectorDataStreamProvider(ConnectorManager.makeInformationSchemaConnectorId(connectorId), new InformationSchemaDataStreamProvider(this.metadataManager, this.splitManager));
        } else {
            this.metadataManager.addGlobalSchemaMetadata(connectorId, connectorMetadata);
        }
        this.splitManager.addConnectorSplitManager(connectorId, connectorSplitManager);
        this.handleResolver.addHandleResolver(connectorId, connectorHandleResolver);
        this.dataStreamManager.addConnectorDataStreamProvider(connectorId, connectorDataStreamProvider);
        if (connectorRecordSinkProvider != null) {
            this.recordSinkManager.addConnectorRecordSinkProvider(connectorId, connectorRecordSinkProvider);
        }
        if (indexResolver != null) {
            this.indexManager.addIndexResolver(connectorId, indexResolver);
        }
    }

    private static String makeInformationSchemaConnectorId(String connectorId) {
        return INFORMATION_SCHEMA_CONNECTOR_PREFIX + connectorId;
    }
}

