/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class ReturnByteCodeExpression
extends ByteCodeExpression {
    private final ByteCodeExpression instance;
    private final OpCode returnOpCode;

    ReturnByteCodeExpression(ByteCodeExpression instance) {
        super(ParameterizedType.type(Void.TYPE));
        this.instance = (ByteCodeExpression)Preconditions.checkNotNull((Object)instance, (Object)"instance is null");
        this.returnOpCode = ReturnByteCodeExpression.returnOpCode(instance.getType());
    }

    @Override
    public ByteCodeNode getByteCode() {
        return new Block(null).append(this.instance.getByteCode()).append(this.returnOpCode);
    }

    @Override
    protected String formatOneLine() {
        return "return " + this.instance;
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.instance);
    }

    private static OpCode returnOpCode(ParameterizedType componentType) {
        Class<?> primitiveType = componentType.getPrimitiveType();
        if (primitiveType != null) {
            if (primitiveType == Byte.TYPE || primitiveType == Boolean.TYPE || primitiveType == Character.TYPE || primitiveType == Short.TYPE || primitiveType == Integer.TYPE) {
                return OpCode.IRETURN;
            }
            if (primitiveType == Long.TYPE) {
                return OpCode.LRETURN;
            }
            if (primitiveType == Float.TYPE) {
                return OpCode.FRETURN;
            }
            if (primitiveType == Double.TYPE) {
                return OpCode.DRETURN;
            }
            if (primitiveType == Void.TYPE) {
                return OpCode.RETURN;
            }
            throw new IllegalArgumentException("Unsupported array type: " + primitiveType);
        }
        return OpCode.ARETURN;
    }
}

