/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpression;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

class NewInstanceByteCodeExpression
extends ByteCodeExpression {
    private final List<ByteCodeExpression> parameters;
    private final ImmutableList<ParameterizedType> parameterTypes;

    public NewInstanceByteCodeExpression(ParameterizedType type, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        super(type);
        this.parameterTypes = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(parameterTypes, (Object)"parameterTypes is null")));
        this.parameters = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(parameters, (Object)"parameters is null")));
    }

    @Override
    public ByteCodeNode getByteCode() {
        Block block = new Block(null).newObject(this.getType()).dup();
        for (ByteCodeExpression parameter : this.parameters) {
            block.append(parameter);
        }
        return block.invokeConstructor(this.getType(), (Iterable<ParameterizedType>)this.parameterTypes);
    }

    @Override
    protected String formatOneLine() {
        return "new " + this.getType().getSimpleName() + "(" + Joiner.on((String)", ").join(this.parameters) + ")";
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.copyOf(this.parameters);
    }
}

