/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class TryCatch
implements FlowControl {
    private final CompilerContext context;
    private final String comment;
    private final ByteCodeNode tryNode;
    private final ByteCodeNode catchNode;
    private final String exceptionName;

    public TryCatch(CompilerContext context, String comment, ByteCodeNode tryNode, ByteCodeNode catchNode, ParameterizedType exceptionType) {
        this.context = (CompilerContext)Preconditions.checkNotNull((Object)context, (Object)"context is null");
        this.comment = comment;
        this.tryNode = (ByteCodeNode)Preconditions.checkNotNull((Object)tryNode, (Object)"tryNode is null");
        this.catchNode = (ByteCodeNode)Preconditions.checkNotNull((Object)catchNode, (Object)"catchNode is null");
        this.exceptionName = exceptionType != null ? exceptionType.getClassName() : null;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public ByteCodeNode getTryNode() {
        return this.tryNode;
    }

    public ByteCodeNode getCatchNode() {
        return this.catchNode;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        LabelNode tryStart = new LabelNode("tryStart");
        LabelNode tryEnd = new LabelNode("tryEnd");
        LabelNode handler = new LabelNode("handler");
        LabelNode done = new LabelNode("done");
        Block block = new Block(this.context);
        block.visitLabel(tryStart).append(this.tryNode).visitLabel(tryEnd).gotoLabel(done);
        block.visitLabel(handler).append(this.catchNode);
        block.visitLabel(done);
        block.accept(visitor);
        visitor.visitTryCatchBlock(tryStart.getLabel(), tryEnd.getLabel(), handler.getLabel(), this.exceptionName);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.tryNode, (Object)this.catchNode);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitTryCatch(parent, this);
    }
}

