/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeNodeFactory;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ExpectedType;

public final class ByteCodeNodes {
    private ByteCodeNodes() {
    }

    public static Block buildBlock(CompilerContext context, ByteCodeNode node) {
        return ByteCodeNodes.buildBlock(context, node, null);
    }

    public static Block buildBlock(CompilerContext context, ByteCodeNode node, String description) {
        Block block = node instanceof Block ? (Block)node : new Block(context).append(node);
        block.setDescription(description);
        return block;
    }

    public static Block buildBlock(CompilerContext context, ByteCodeNodeFactory factory, ExpectedType expectedType) {
        return ByteCodeNodes.buildBlock(context, factory, expectedType, null);
    }

    public static Block buildBlock(CompilerContext context, ByteCodeNodeFactory factory, ExpectedType expectedType, String description) {
        ByteCodeNode node = factory.build(context, expectedType);
        Block block = node instanceof Block ? (Block)node : new Block(context).append(node);
        block.setDescription(description);
        return block;
    }
}

