/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.util.Iterator;

public class PackedLongSerde {
    private final byte bitWidth;
    private final long min;
    private final long max;

    public PackedLongSerde(int bitWidth) {
        Preconditions.checkArgument((bitWidth > 0 && bitWidth <= 64 ? 1 : 0) != 0);
        this.bitWidth = (byte)bitWidth;
        this.min = -1L << bitWidth - 1;
        this.max = -1L << bitWidth - 1 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void serialize(Iterable<Long> items, SliceOutput sliceOutput) {
        int packCapacity = 64 / this.bitWidth;
        long mask = -1L >>> 64 - this.bitWidth;
        int itemCount = 0;
        Iterator<Long> iter = items.iterator();
        while (iter.hasNext()) {
            long pack = 0L;
            boolean packUsed = false;
            for (int index = 0; index < packCapacity && iter.hasNext(); ++index) {
                long rawValue = iter.next();
                Preconditions.checkArgument((this.min <= rawValue && rawValue <= this.max ? 1 : 0) != 0, (Object)"Provided value does not fit into bitspace");
                long maskedValue = rawValue & mask;
                ++itemCount;
                pack |= maskedValue << this.bitWidth * index;
                packUsed = true;
            }
            if (!packUsed) continue;
            sliceOutput.writeLong(pack);
        }
        new Footer(itemCount, this.bitWidth).serialize(sliceOutput);
    }

    public static Iterable<Long> deserialize(final SliceInput sliceInput) {
        Preconditions.checkArgument((sliceInput.available() >= 5 ? 1 : 0) != 0, (Object)"sliceInput not large enough to read a footer");
        Preconditions.checkArgument(((sliceInput.available() - 5) % 8 == 0 ? 1 : 0) != 0, (Object)"sliceInput byte alignment incorrect");
        int totalBytes = sliceInput.available();
        sliceInput.skipBytes(totalBytes - 5);
        final Footer footer = Footer.deserialize((SliceInput)sliceInput.readSlice(5).getInput());
        sliceInput.setPosition(0);
        final int packCapacity = 64 / footer.getBitWidth();
        return new Iterable<Long>(){

            @Override
            public Iterator<Long> iterator() {
                return new AbstractIterator<Long>(){
                    private int itemIndex = 0;
                    private int packInternalIndex = 0;
                    private long packValue = 0L;

                    protected Long computeNext() {
                        if (this.itemIndex >= footer.getItemCount()) {
                            return (Long)this.endOfData();
                        }
                        if (this.packInternalIndex == 0) {
                            this.packValue = sliceInput.readLong();
                        }
                        long value = this.packValue << 64 - (this.packInternalIndex + 1) * footer.getBitWidth() >> 64 - footer.getBitWidth();
                        ++this.itemIndex;
                        this.packInternalIndex = (this.packInternalIndex + 1) % packCapacity;
                        return value;
                    }
                };
            }
        };
    }

    private static class Footer {
        private static final int BYTE_SIZE = 5;
        private final int itemCount;
        private final byte bitWidth;

        private Footer(int itemCount, byte bitWidth) {
            Preconditions.checkArgument((itemCount >= 0 ? 1 : 0) != 0, (Object)"itemCount must be non-negative");
            Preconditions.checkArgument((bitWidth > 0 ? 1 : 0) != 0, (Object)"bitWidth must be greater than zero");
            this.itemCount = itemCount;
            this.bitWidth = bitWidth;
        }

        public int serialize(SliceOutput sliceOutput) {
            sliceOutput.writeInt(this.itemCount);
            sliceOutput.writeByte((int)this.bitWidth);
            return 5;
        }

        public static Footer deserialize(SliceInput sliceInput) {
            int itemCount = sliceInput.readInt();
            byte bitWidth = sliceInput.readByte();
            return new Footer(itemCount, bitWidth);
        }

        public int getItemCount() {
            return this.itemCount;
        }

        public byte getBitWidth() {
            return this.bitWidth;
        }
    }
}

