/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.dictionary.DictionaryBlockEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public class DictionaryEncodedBlock
implements Block {
    private static final FixedWidthBlock NULL_SINGLE_VALUE_BLOCK = new FixedWidthBlock(0, 1, Slices.EMPTY_SLICE, new boolean[]{true});
    private final Block dictionary;
    private final Block idBlock;

    public DictionaryEncodedBlock(Block dictionary, Block idBlock) {
        this.dictionary = (Block)Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        this.idBlock = (Block)Preconditions.checkNotNull((Object)idBlock, (Object)"idBlock is null");
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    public Block getIdBlock() {
        return this.idBlock;
    }

    public int getPositionCount() {
        return this.idBlock.getPositionCount();
    }

    public int getSizeInBytes() {
        return Ints.checkedCast((long)(this.dictionary.getSizeInBytes() + this.idBlock.getSizeInBytes()));
    }

    public BlockEncoding getEncoding() {
        return new DictionaryBlockEncoding(this.dictionary, this.idBlock.getEncoding());
    }

    public Block getRegion(int positionOffset, int length) {
        return new DictionaryEncodedBlock(this.dictionary, this.idBlock.getRegion(positionOffset, length));
    }

    public int getLength(int position) {
        return this.dictionary.getLength(this.getDictionaryKey(position));
    }

    public byte getByte(int position, int offset) {
        return this.dictionary.getByte(this.getDictionaryKey(position), offset);
    }

    public short getShort(int position, int offset) {
        return this.dictionary.getShort(this.getDictionaryKey(position), offset);
    }

    public int getInt(int position, int offset) {
        return this.dictionary.getInt(this.getDictionaryKey(position), offset);
    }

    public long getLong(int position, int offset) {
        return this.dictionary.getLong(this.getDictionaryKey(position), offset);
    }

    public float getFloat(int position, int offset) {
        return this.dictionary.getFloat(this.getDictionaryKey(position), offset);
    }

    public double getDouble(int position, int offset) {
        return this.dictionary.getDouble(this.getDictionaryKey(position), offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.dictionary.getSlice(this.getDictionaryKey(position), offset, length);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.dictionary.bytesEqual(this.getDictionaryKey(position), offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.dictionary.bytesCompare(this.getDictionaryKey(position), offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.dictionary.writeBytesTo(this.getDictionaryKey(position), offset, length, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.dictionary.equals(this.getDictionaryKey(position), offset, otherBlock, otherPosition, otherOffset, length);
    }

    public int hash(int position, int offset, int length) {
        return this.dictionary.hash(this.getDictionaryKey(position), offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.dictionary.compareTo(this.getDictionaryKey(leftPosition), leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        if (this.isNull(position)) {
            return NULL_SINGLE_VALUE_BLOCK;
        }
        return this.dictionary.getSingleValueBlock(this.getDictionaryKey(position));
    }

    public boolean isNull(int position) {
        return this.idBlock.isNull(position) || this.dictionary.isNull(this.getDictionaryKey(position));
    }

    private int getDictionaryKey(int position) {
        return Ints.checkedCast((long)BigintType.BIGINT.getLong(this.idBlock, position));
    }
}

