/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.PagePartitionFunction;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class HashPagePartitionFunction
implements PagePartitionFunction {
    private final int partition;
    private final int partitionCount;
    private final List<Integer> partitioningChannels;
    private final List<Type> types;

    @JsonCreator
    public HashPagePartitionFunction(@JsonProperty(value="partition") int partition, @JsonProperty(value="partitionCount") int partitionCount, @JsonProperty(value="partitioningChannels") List<Integer> partitioningChannels, @JsonProperty(value="types") List<Type> types) {
        this.partition = partition;
        this.partitionCount = partitionCount;
        this.partitioningChannels = ImmutableList.copyOf(partitioningChannels);
        this.types = ImmutableList.copyOf(types);
    }

    @JsonProperty
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @JsonProperty
    public List<Integer> getPartitioningChannels() {
        return this.partitioningChannels;
    }

    @JsonProperty
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public List<Page> partition(List<Page> pages) {
        if (pages.isEmpty()) {
            return pages;
        }
        PageBuilder pageBuilder = new PageBuilder(this.types);
        ImmutableList.Builder partitionedPages = ImmutableList.builder();
        for (Page page : pages) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int partitionHashBucket = this.getPartitionHashBucket(position, page);
                if (partitionHashBucket != this.partition) continue;
                for (int channel = 0; channel < this.types.size(); ++channel) {
                    Type type = this.types.get(channel);
                    type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
                }
                if (!pageBuilder.isFull()) continue;
                partitionedPages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
        }
        if (!pageBuilder.isEmpty()) {
            partitionedPages.add((Object)pageBuilder.build());
        }
        return partitionedPages.build();
    }

    private int getPartitionHashBucket(int position, Page page) {
        long hashCode = 1L;
        for (int channel : this.partitioningChannels) {
            hashCode *= 31L;
            Type type = this.types.get(channel);
            Block block = page.getBlock(channel);
            hashCode += (long)TypeUtils.hashPosition(type, block, position);
        }
        int bucket = (int)((hashCode &= Long.MAX_VALUE) % (long)this.partitionCount);
        Preconditions.checkState((bucket >= 0 && bucket < this.partitionCount ? 1 : 0) != 0);
        return bucket;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.partition, this.partitionCount, this.partitioningChannels});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HashPagePartitionFunction other = (HashPagePartitionFunction)obj;
        return Objects.equal((Object)this.partition, (Object)other.partition) && Objects.equal((Object)this.partitionCount, (Object)other.partitionCount) && Objects.equal(this.partitioningChannels, other.partitioningChannels);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("partition", this.partition).add("partitionCount", this.partitionCount).add("partitioningChannels", this.partitioningChannels).toString();
    }
}

