/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.FixedWidthType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SqlDecimal;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class TypeJsonUtils {
    private static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(JSON_FACTORY);

    private TypeJsonUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object stackRepresentationToObject(ConnectorSession session, Slice value, Type type) {
        if (value == null) {
            return null;
        }
        try (JsonParser jsonParser = JSON_FACTORY.createParser((InputStream)value.getInput());){
            jsonParser.nextToken();
            Object object = TypeJsonUtils.stackRepresentationToObjectHelper(session, jsonParser, type);
            return object;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static Object stackRepresentationToObjectHelper(ConnectorSession session, JsonParser parser, Type type) throws IOException {
        if (type instanceof JsonType) {
            return OBJECT_MAPPER.writeValueAsString((Object)parser.readValueAsTree());
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (type instanceof ArrayType) {
            ArrayList<Object> list = new ArrayList<Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (Object)"Expected a json array");
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                list.add(TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((ArrayType)type).getElementType()));
            }
            return Collections.unmodifiableList(list);
        }
        if (type instanceof MapType) {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_OBJECT ? 1 : 0) != 0, (Object)"Expected a json object");
            while (parser.nextValue() != JsonToken.END_OBJECT) {
                Object key = TypeJsonUtils.mapKeyToObject(session, parser.getCurrentName(), ((MapType)type).getKeyType());
                Object value = TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, ((MapType)type).getValueType());
                map.put(key, value);
            }
            return Collections.unmodifiableMap(map);
        }
        if (type instanceof RowType) {
            ArrayList<Object> list = new ArrayList<Object>();
            Preconditions.checkState((parser.getCurrentToken() == JsonToken.START_ARRAY ? 1 : 0) != 0, (Object)"Expected a json array");
            int field = 0;
            RowType rowType = (RowType)type;
            while (parser.nextValue() != JsonToken.END_ARRAY) {
                Preconditions.checkArgument((field < rowType.getFields().size() ? 1 : 0) != 0, (String)"Unexpected field for type %s", (Object)type);
                Object value = TypeJsonUtils.stackRepresentationToObjectHelper(session, parser, rowType.getFields().get(field).getType());
                list.add(value);
                ++field;
            }
            Preconditions.checkArgument((field == rowType.getFields().size() ? 1 : 0) != 0, (String)"Expected %s fields for type %s", (int)rowType.getFields().size(), (Object)type);
            return Collections.unmodifiableList(list);
        }
        Slice sliceValue = null;
        if (type.getJavaType() == Slice.class) {
            sliceValue = Slices.utf8Slice((String)parser.getValueAsString());
        }
        BlockBuilder blockBuilder = type instanceof FixedWidthType ? type.createBlockBuilder(new BlockBuilderStatus(), 1) : type.createBlockBuilder(new BlockBuilderStatus(), 1, Objects.requireNonNull(sliceValue, "sliceValue is null").length());
        if (type instanceof DecimalType) {
            return TypeJsonUtils.getSqlDecimal((DecimalType)type, parser.getDecimalValue());
        }
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, parser.getBooleanValue());
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, parser.getLongValue());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, TypeJsonUtils.getDoubleValue(parser));
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Objects.requireNonNull(sliceValue, "sliceValue is null"));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    private static SqlDecimal getSqlDecimal(DecimalType decimalType, BigDecimal decimalValue) {
        BigInteger unscaledValue = decimalValue.setScale(decimalType.getScale(), RoundingMode.HALF_UP).unscaledValue();
        if (Decimals.overflows((BigInteger)unscaledValue, (int)decimalType.getPrecision())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("DECIMAL with unscaled value %s exceeds precision %s", unscaledValue, decimalType.getPrecision()));
        }
        return new SqlDecimal(unscaledValue, decimalType.getPrecision(), decimalType.getScale());
    }

    private static Object mapKeyToObject(ConnectorSession session, String jsonKey, Type type) {
        BlockBuilder blockBuilder = type instanceof FixedWidthType ? type.createBlockBuilder(new BlockBuilderStatus(), 1) : type.createBlockBuilder(new BlockBuilderStatus(), 1, jsonKey.length());
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return TypeJsonUtils.getSqlDecimal(decimalType, new BigDecimal(jsonKey));
        }
        if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, Boolean.parseBoolean(jsonKey));
        } else if (type.getJavaType() == Long.TYPE) {
            type.writeLong(blockBuilder, Long.parseLong(jsonKey));
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(blockBuilder, Double.parseDouble(jsonKey));
        } else if (type.getJavaType() == Slice.class) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)jsonKey));
        }
        return type.getObjectValue(session, blockBuilder.build(), 0);
    }

    private static double getDoubleValue(JsonParser parser) throws IOException {
        double value;
        try {
            value = parser.getDoubleValue();
        }
        catch (JsonParseException e) {
            value = Double.parseDouble(parser.getValueAsString());
        }
        return value;
    }

    public static boolean canCastFromJson(Type type) {
        String baseType = type.getTypeSignature().getBase();
        if (baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("double") || baseType.equals("varchar") || baseType.equals("decimal") || baseType.equals("json")) {
            return true;
        }
        if (type instanceof ArrayType) {
            return TypeJsonUtils.canCastFromJson(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return TypeJsonUtils.isValidJsonObjectKeyType(((MapType)type).getKeyType()) && TypeJsonUtils.canCastFromJson(((MapType)type).getValueType());
        }
        return false;
    }

    private static boolean isValidJsonObjectKeyType(Type type) {
        String baseType = type.getTypeSignature().getBase();
        return baseType.equals("boolean") || baseType.equals("tinyint") || baseType.equals("smallint") || baseType.equals("integer") || baseType.equals("bigint") || baseType.equals("double") || baseType.equals("decimal") || baseType.equals("varchar");
    }

    @VisibleForTesting
    public static void appendToBlockBuilder(Type type, Object element, BlockBuilder blockBuilder) {
        Class javaType = type.getJavaType();
        if (element == null) {
            blockBuilder.appendNull();
        } else if (type.getTypeSignature().getBase().equals("array") && element instanceof Iterable) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object subElement : (Iterable)element) {
                TypeJsonUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(0), subElement, subBlockBuilder);
            }
            blockBuilder.closeEntry();
        } else if (type.getTypeSignature().getBase().equals("row") && element instanceof Iterable) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            int field = 0;
            for (Object subElement : (Iterable)element) {
                TypeJsonUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(field), subElement, subBlockBuilder);
                ++field;
            }
            blockBuilder.closeEntry();
        } else if (type.getTypeSignature().getBase().equals("map") && element instanceof Map) {
            BlockBuilder subBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : ((Map)element).entrySet()) {
                TypeJsonUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(0), entry.getKey(), subBlockBuilder);
                TypeJsonUtils.appendToBlockBuilder((Type)type.getTypeParameters().get(1), entry.getValue(), subBlockBuilder);
            }
            blockBuilder.closeEntry();
        } else if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
        } else if (javaType == Long.TYPE) {
            if (element instanceof SqlDecimal) {
                type.writeLong(blockBuilder, ((SqlDecimal)element).getUnscaledValue().longValue());
            } else if (RealType.REAL.equals((Object)type)) {
                type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(((Number)element).floatValue()));
            } else {
                type.writeLong(blockBuilder, ((Number)element).longValue());
            }
        } else if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)element).doubleValue());
        } else if (javaType == Slice.class) {
            if (element instanceof String) {
                type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
            } else if (element instanceof byte[]) {
                type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])element)));
            } else if (element instanceof SqlDecimal) {
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue((BigInteger)((SqlDecimal)element).getUnscaledValue()));
            } else {
                type.writeSlice(blockBuilder, (Slice)element);
            }
        } else {
            type.writeObject(blockBuilder, element);
        }
    }
}

