/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.math.BigInteger;
import java.util.Set;

public class DecimalInequalityOperators {
    private static final TypeSignature DECIMAL_SIGNATURE = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
    private static final MethodHandle IS_RESULT_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "getResultEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_NOT_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultNotEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_LESS_THAN = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultLessThan", Integer.TYPE);
    private static final MethodHandle IS_RESULT_LESS_THAN_OR_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultLessThanOrEqual", Integer.TYPE);
    private static final MethodHandle IS_RESULT_GREATER_THAN = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultGreaterThan", Integer.TYPE);
    private static final MethodHandle IS_RESULT_GREATER_THAN_OR_EQUAL = Reflection.methodHandle(DecimalInequalityOperators.class, "isResultGreaterThanOrEqual", Integer.TYPE);
    public static final SqlScalarFunction DECIMAL_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.EQUAL, IS_RESULT_EQUAL);
    public static final SqlScalarFunction DECIMAL_NOT_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.NOT_EQUAL, IS_RESULT_NOT_EQUAL);
    public static final SqlScalarFunction DECIMAL_LESS_THAN_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.LESS_THAN, IS_RESULT_LESS_THAN);
    public static final SqlScalarFunction DECIMAL_LESS_THAN_OR_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, IS_RESULT_LESS_THAN_OR_EQUAL);
    public static final SqlScalarFunction DECIMAL_GREATER_THAN_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.GREATER_THAN, IS_RESULT_GREATER_THAN);
    public static final SqlScalarFunction DECIMAL_GREATER_THAN_OR_EQUAL_OPERATOR = DecimalInequalityOperators.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, IS_RESULT_GREATER_THAN_OR_EQUAL);
    public static final SqlScalarFunction DECIMAL_BETWEEN_OPERATOR = DecimalInequalityOperators.betweenOperator();
    public static final SqlScalarFunction DECIMAL_DISTINCT_FROM_OPERATOR = DecimalInequalityOperators.binaryOperatorNullable(OperatorType.IS_DISTINCT_FROM, IS_RESULT_NOT_EQUAL);

    private DecimalInequalityOperators() {
    }

    @UsedByGeneratedCode
    public static boolean getResultEqual(int comparisonResult) {
        return comparisonResult == 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultNotEqual(int comparisonResult) {
        return comparisonResult != 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultLessThan(int comparisonResult) {
        return comparisonResult < 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultLessThanOrEqual(int comparisonResult) {
        return comparisonResult <= 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultGreaterThan(int comparisonResult) {
        return comparisonResult > 0;
    }

    @UsedByGeneratedCode
    public static boolean isResultGreaterThanOrEqual(int comparisonResult) {
        return comparisonResult >= 0;
    }

    private static SqlScalarFunctionBuilder makeBinaryOperatorFunctionBuilder(OperatorType operatorType) {
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(operatorType).argumentTypes(DECIMAL_SIGNATURE, DECIMAL_SIGNATURE).returnType(TypeSignature.parseTypeSignature((String)"boolean")).build();
        return SqlScalarFunction.builder(DecimalInequalityOperators.class).signature(signature);
    }

    private static SqlScalarFunction binaryOperator(OperatorType operatorType, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.makeBinaryOperatorFunctionBuilder(operatorType).implementation(b -> b.methods("opShortShort", "opLongLong").withExtraParameters(SqlScalarFunctionBuilder.constant(getResultMethodHandle))).build();
    }

    private static SqlScalarFunction binaryOperatorNullable(OperatorType operatorType, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.makeBinaryOperatorFunctionBuilder(operatorType).nullableArguments(true, true).nullFlags(true, true).implementation(b -> b.methods("opShortShortShortNullable", "opLongLongNullable").withExtraParameters(SqlScalarFunctionBuilder.constant(getResultMethodHandle))).build();
    }

    @UsedByGeneratedCode
    public static boolean opShortShort(long a, long b, MethodHandle getResultMethodHandle) {
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, Long.compare(a, b));
    }

    @UsedByGeneratedCode
    public static boolean opShortShortShortNullable(long a, boolean aNull, long b, boolean bNull, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull) {
            return false;
        }
        return DecimalInequalityOperators.opShortShort(a, b, getResultMethodHandle);
    }

    @UsedByGeneratedCode
    public static boolean opLongLong(Slice a, Slice b, MethodHandle getResultMethodHandle) {
        BigInteger left = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger right = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalInequalityOperators.invokeGetResult(getResultMethodHandle, left.compareTo(right));
    }

    @UsedByGeneratedCode
    public static boolean opLongLongNullable(Slice a, boolean aNull, Slice b, boolean bNull, MethodHandle getResultMethodHandle) {
        if (aNull != bNull) {
            return true;
        }
        if (aNull && bNull) {
            return false;
        }
        return DecimalInequalityOperators.opLongLong(a, b, getResultMethodHandle);
    }

    private static boolean invokeGetResult(MethodHandle getResultMethodHandle, int comparisonResult) {
        try {
            return getResultMethodHandle.invokeExact(comparisonResult);
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    private static SqlScalarFunction betweenOperator() {
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.BETWEEN).argumentTypes(DECIMAL_SIGNATURE, DECIMAL_SIGNATURE, DECIMAL_SIGNATURE).returnType(TypeSignature.parseTypeSignature((String)"boolean")).build();
        return SqlScalarFunction.builder(DecimalInequalityOperators.class).signature(signature).implementation(b -> b.methods("betweenShortShortShort", "betweenLongLongLong")).build();
    }

    @UsedByGeneratedCode
    public static boolean betweenShortShortShort(long value, long low, long high) {
        return low <= value && value <= high;
    }

    @UsedByGeneratedCode
    public static boolean betweenLongLongLong(Slice valueSlice, Slice lowSlice, Slice highSlice) {
        BigInteger value = Decimals.decodeUnscaledValue((Slice)valueSlice);
        BigInteger low = Decimals.decodeUnscaledValue((Slice)lowSlice);
        BigInteger high = Decimals.decodeUnscaledValue((Slice)highSlice);
        return low.compareTo(value) <= 0 && value.compareTo(high) <= 0;
    }
}

