/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlDecimal;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTimeZone;

public class MaterializedResult
implements Iterable<MaterializedRow> {
    public static final int DEFAULT_PRECISION = 5;
    private final List<MaterializedRow> rows;
    private final List<Type> types;
    private final Map<String, String> setSessionProperties;
    private final Set<String> resetSessionProperties;
    private final Optional<String> updateType;
    private final OptionalLong updateCount;

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types) {
        this(rows, types, (Map<String, String>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), Optional.empty(), OptionalLong.empty());
    }

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types, Map<String, String> setSessionProperties, Set<String> resetSessionProperties, Optional<String> updateType, OptionalLong updateCount) {
        this.rows = ImmutableList.copyOf((Collection)Objects.requireNonNull(rows, "rows is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.setSessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(setSessionProperties, "setSessionProperties is null"));
        this.resetSessionProperties = ImmutableSet.copyOf((Collection)Objects.requireNonNull(resetSessionProperties, "resetSessionProperties is null"));
        this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        this.updateCount = Objects.requireNonNull(updateCount, "updateCount is null");
    }

    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Iterator<MaterializedRow> iterator() {
        return this.rows.iterator();
    }

    public List<MaterializedRow> getMaterializedRows() {
        return this.rows;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    public OptionalLong getUpdateCount() {
        return this.updateCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedResult o = (MaterializedResult)obj;
        return Objects.equals(this.types, o.types) && Objects.equals(this.rows, o.rows) && Objects.equals(this.setSessionProperties, o.setSessionProperties) && Objects.equals(this.resetSessionProperties, o.resetSessionProperties) && Objects.equals(this.updateType, o.updateType) && Objects.equals(this.updateCount, o.updateCount);
    }

    public int hashCode() {
        return Objects.hash(this.rows, this.types, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rows", this.rows).add("types", this.types).add("setSessionProperties", this.setSessionProperties).add("resetSessionProperties", this.resetSessionProperties).add("updateType", this.updateType.orElse(null)).add("updateCount", this.updateCount.isPresent() ? Long.valueOf(this.updateCount.getAsLong()) : null).omitNullValues().toString();
    }

    public Set<String> getOnlyColumnAsSet() {
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return (Set)this.rows.stream().map(row -> (String)row.getField(0)).collect(ImmutableCollectors.toImmutableSet());
    }

    public Object getOnlyValue() {
        Preconditions.checkState((this.rows.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one row");
        Preconditions.checkState((this.types.size() == 1 ? 1 : 0) != 0, (Object)"result set must have exactly one column");
        return this.rows.get(0).getField(0);
    }

    public Page toPage() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        for (MaterializedRow row : this.rows) {
            MaterializedResult.appendToPage(pageBuilder, row);
        }
        return pageBuilder.build();
    }

    private static void appendToPage(PageBuilder pageBuilder, MaterializedRow row) {
        for (int field = 0; field < row.getFieldCount(); ++field) {
            Type type = pageBuilder.getType(field);
            Object value = row.getField(field);
            BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(field);
            MaterializedResult.writeValue(type, blockBuilder, value);
        }
        pageBuilder.declarePosition();
    }

    private static void writeValue(Type type, BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (BigintType.BIGINT.equals((Object)type)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Number)value).intValue());
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Number)value).shortValue());
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)((Number)value).byteValue());
        } else if (RealType.REAL.equals((Object)type)) {
            type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(((Number)value).floatValue()));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            type.writeDouble(blockBuilder, ((Number)value).doubleValue());
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
        } else if (VarcharType.VARCHAR.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.utf8Slice((String)((String)value)));
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])value)));
        } else if (DateType.DATE.equals((Object)type)) {
            int days = ((SqlDate)value).getDays();
            type.writeLong(blockBuilder, (long)days);
        } else if (TimeType.TIME.equals((Object)type)) {
            long millisUtc = ((SqlTime)value).getMillisUtc();
            type.writeLong(blockBuilder, millisUtc);
        } else if (TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.equals((Object)type)) {
            long millisUtc = ((SqlTimeWithTimeZone)value).getMillisUtc();
            TimeZoneKey timeZoneKey = ((SqlTimeWithTimeZone)value).getTimeZoneKey();
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            long millisUtc = ((SqlTimestamp)value).getMillisUtc();
            type.writeLong(blockBuilder, millisUtc);
        } else if (TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.equals((Object)type)) {
            long millisUtc = ((SqlTimestampWithTimeZone)value).getMillisUtc();
            TimeZoneKey timeZoneKey = ((SqlTimestampWithTimeZone)value).getTimeZoneKey();
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)timeZoneKey));
        } else if ("array".equals(type.getTypeSignature().getBase())) {
            List list = (List)value;
            Type elementType = ((ArrayType)type).getElementType();
            BlockBuilder arrayBlockBuilder = blockBuilder.beginBlockEntry();
            for (Object element : list) {
                MaterializedResult.writeValue(elementType, arrayBlockBuilder, element);
            }
            blockBuilder.closeEntry();
        } else if ("map".equals(type.getTypeSignature().getBase())) {
            Map map = (Map)value;
            Type keyType = ((MapType)type).getKeyType();
            Type valueType = ((MapType)type).getValueType();
            BlockBuilder mapBlockBuilder = blockBuilder.beginBlockEntry();
            for (Map.Entry entry : map.entrySet()) {
                MaterializedResult.writeValue(keyType, mapBlockBuilder, entry.getKey());
                MaterializedResult.writeValue(valueType, mapBlockBuilder, entry.getValue());
            }
            blockBuilder.closeEntry();
        } else if (type instanceof RowType) {
            List row = (List)value;
            List fieldTypes = type.getTypeParameters();
            BlockBuilder rowBlockBuilder = blockBuilder.beginBlockEntry();
            for (int field = 0; field < row.size(); ++field) {
                MaterializedResult.writeValue((Type)fieldTypes.get(field), rowBlockBuilder, row.get(field));
            }
            blockBuilder.closeEntry();
        } else {
            throw new IllegalArgumentException("Unsupported type " + type);
        }
    }

    public MaterializedResult toJdbcTypes() {
        ImmutableList.Builder jdbcRows = ImmutableList.builder();
        for (MaterializedRow row : this.rows) {
            jdbcRows.add((Object)MaterializedResult.convertToJdbcTypes(row));
        }
        return new MaterializedResult((List<MaterializedRow>)jdbcRows.build(), this.types, this.setSessionProperties, this.resetSessionProperties, this.updateType, this.updateCount);
    }

    private static MaterializedRow convertToJdbcTypes(MaterializedRow prestoRow) {
        ArrayList<Object> jdbcValues = new ArrayList<Object>();
        for (int field = 0; field < prestoRow.getFieldCount(); ++field) {
            Object jdbcValue;
            Object prestoValue = prestoRow.getField(field);
            if (prestoValue instanceof SqlDate) {
                int days = ((SqlDate)prestoValue).getDays();
                jdbcValue = new Date(TimeUnit.DAYS.toMillis(days));
            } else {
                jdbcValue = prestoValue instanceof SqlTime ? new Time(((SqlTime)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimeWithTimeZone ? new Time(((SqlTimeWithTimeZone)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestamp ? new Timestamp(((SqlTimestamp)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestampWithTimeZone ? new Timestamp(((SqlTimestampWithTimeZone)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlDecimal ? ((SqlDecimal)prestoValue).toBigDecimal() : prestoValue))));
            }
            jdbcValues.add(jdbcValue);
        }
        return new MaterializedRow(prestoRow.getPrecision(), jdbcValues);
    }

    public MaterializedResult toTimeZone(DateTimeZone oldTimeZone, DateTimeZone newTimeZone) {
        ImmutableList.Builder jdbcRows = ImmutableList.builder();
        for (MaterializedRow row : this.rows) {
            jdbcRows.add((Object)MaterializedResult.toTimeZone(row, oldTimeZone, newTimeZone));
        }
        return new MaterializedResult((List<MaterializedRow>)jdbcRows.build(), this.types);
    }

    private static MaterializedRow toTimeZone(MaterializedRow prestoRow, DateTimeZone oldTimeZone, DateTimeZone newTimeZone) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int field = 0; field < prestoRow.getFieldCount(); ++field) {
            Object value = prestoRow.getField(field);
            if (value instanceof Date) {
                long oldMillis = ((Date)value).getTime();
                long newMillis = oldTimeZone.getMillisKeepLocal(newTimeZone, oldMillis);
                value = new Date(newMillis);
            }
            values.add(value);
        }
        return new MaterializedRow(prestoRow.getPrecision(), values);
    }

    public static MaterializedResult materializeSourceDataStream(Session session, ConnectorPageSource pageSource, List<Type> types) {
        return MaterializedResult.materializeSourceDataStream(session.toConnectorSession(), pageSource, types);
    }

    public static MaterializedResult materializeSourceDataStream(ConnectorSession session, ConnectorPageSource pageSource, List<Type> types) {
        Page outputPage;
        Builder builder = MaterializedResult.resultBuilder(session, types);
        while (!pageSource.isFinished() && (outputPage = pageSource.getNextPage()) != null) {
            builder.page(outputPage);
        }
        return builder.build();
    }

    public static Builder resultBuilder(Session session, Type ... types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(Session session, Iterable<? extends Type> types) {
        return MaterializedResult.resultBuilder(session.toConnectorSession(), types);
    }

    public static Builder resultBuilder(ConnectorSession session, Type ... types) {
        return MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static Builder resultBuilder(ConnectorSession session, Iterable<? extends Type> types) {
        return new Builder(session, (List<Type>)ImmutableList.copyOf(types));
    }

    public static class Builder {
        private final ConnectorSession session;
        private final List<Type> types;
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();

        Builder(ConnectorSession session, List<Type> types) {
            this.session = session;
            this.types = ImmutableList.copyOf(types);
        }

        public synchronized Builder rows(List<MaterializedRow> rows) {
            this.rows.addAll(rows);
            return this;
        }

        public synchronized Builder row(Object ... values) {
            this.rows.add((Object)new MaterializedRow(5, values));
            return this;
        }

        public synchronized Builder rows(Object[][] rows) {
            for (Object[] row : rows) {
                this.row(row);
            }
            return this;
        }

        public synchronized Builder pages(Iterable<Page> pages) {
            for (Page page : pages) {
                this.page(page);
            }
            return this;
        }

        public synchronized Builder page(Page page) {
            Objects.requireNonNull(page, "page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (int)this.types.size(), (int)page.getChannelCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, position));
                }
                values = Collections.unmodifiableList(values);
                this.rows.add((Object)new MaterializedRow(5, values));
            }
            return this;
        }

        public synchronized MaterializedResult build() {
            return new MaterializedResult((List<MaterializedRow>)this.rows.build(), this.types);
        }
    }
}

