/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SortNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> orderBy;
    private final Map<Symbol, SortOrder> orderings;

    @JsonCreator
    public SortNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="orderBy") List<Symbol> orderBy, @JsonProperty(value="orderings") Map<Symbol, SortOrder> orderings) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Preconditions.checkArgument((!orderBy.isEmpty() ? 1 : 0) != 0, (Object)"orderBy is empty");
        Preconditions.checkArgument((orderings.size() == orderBy.size() ? 1 : 0) != 0, (Object)"orderBy and orderings sizes don't match");
        this.source = source;
        this.orderBy = ImmutableList.copyOf(orderBy);
        this.orderings = ImmutableMap.copyOf(orderings);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.source.getOutputSymbols();
    }

    @JsonProperty(value="orderBy")
    public List<Symbol> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty(value="orderings")
    public Map<Symbol, SortOrder> getOrderings() {
        return this.orderings;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitSort(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SortNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.orderBy, this.orderings);
    }
}

