/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TransformUncorrelatedInPredicateSubqueryToSemiJoin
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new InPredicateRewriter(idAllocator), plan, null);
    }

    private static class InPredicateRewriter
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;

        public InPredicateRewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            if (!node.getCorrelation().isEmpty()) {
                return context.defaultRewrite(node);
            }
            if (node.getSubqueryAssignments().size() != 1) {
                return context.defaultRewrite(node);
            }
            Expression expression = (Expression)Iterables.getOnlyElement(node.getSubqueryAssignments().getExpressions());
            if (!(expression instanceof InPredicate)) {
                return context.defaultRewrite(node);
            }
            PlanNode input = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            InPredicate inPredicate = (InPredicate)expression;
            Symbol semiJoinSymbol = (Symbol)Iterables.getOnlyElement(node.getSubqueryAssignments().getSymbols());
            return new SemiJoinNode(this.idAllocator.getNextId(), input, subquery, Symbol.from(inPredicate.getValue()), Symbol.from(inPredicate.getValueList()), semiJoinSymbol, Optional.empty(), Optional.empty());
        }
    }
}

