/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Deprecated
public class TransformExistsApplyToScalarApply
implements PlanOptimizer {
    private final Metadata metadata;

    public TransformExistsApplyToScalarApply(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator, symbolAllocator, this.metadata), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final Metadata metadata;

        public Rewriter(PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Metadata metadata) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        public PlanNode visitApply(ApplyNode node, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            if (node.getSubqueryAssignments().size() != 1) {
                return context.defaultRewrite(node);
            }
            Expression expression = (Expression)Iterables.getOnlyElement(node.getSubqueryAssignments().getExpressions());
            if (!(expression instanceof ExistsPredicate)) {
                return context.defaultRewrite(node);
            }
            PlanNode input = context.rewrite(node.getInput());
            PlanNode subquery = context.rewrite(node.getSubquery());
            subquery = new LimitNode(this.idAllocator.getNextId(), subquery, 1L, false);
            FunctionRegistry functionRegistry = this.metadata.getFunctionRegistry();
            QualifiedName countFunction = QualifiedName.of((String)"count");
            Symbol count = this.symbolAllocator.newSymbol(countFunction.toString(), (Type)BigintType.BIGINT);
            subquery = new AggregationNode(this.idAllocator.getNextId(), subquery, (Map<Symbol, FunctionCall>)ImmutableMap.of((Object)count, (Object)new FunctionCall(countFunction, (List)ImmutableList.of())), (Map<Symbol, Signature>)ImmutableMap.of((Object)count, (Object)functionRegistry.resolveFunction(countFunction, (List<TypeSignatureProvider>)ImmutableList.of())), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of()), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty());
            ComparisonExpression countGreaterThanZero = new ComparisonExpression(ComparisonExpressionType.GREATER_THAN, (Expression)count.toSymbolReference(), (Expression)new Cast((Expression)new LongLiteral("0"), BigintType.BIGINT.toString()));
            Symbol existsSymbol = (Symbol)Iterables.getOnlyElement(node.getSubqueryAssignments().getSymbols());
            subquery = new ProjectNode(this.idAllocator.getNextId(), subquery, Assignments.of(existsSymbol, (Expression)countGreaterThanZero));
            return new ApplyNode(node.getId(), input, subquery, Assignments.of(existsSymbol, (Expression)existsSymbol.toSymbolReference()), node.getCorrelation());
        }
    }
}

