/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;

public class ReorderWindows
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        if (!SystemSessionProperties.isReorderWindowsEnabled(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan, new PriorityQueue<WindowNode>(new PartitionByComparator()));
    }

    private static class PartitionByComparator
    implements Comparator<WindowNode> {
        private PartitionByComparator() {
        }

        @Override
        public int compare(WindowNode o1, WindowNode o2) {
            Iterator<Symbol> iterator1 = o1.getPartitionBy().iterator();
            Iterator<Symbol> iterator2 = o2.getPartitionBy().iterator();
            while (iterator1.hasNext() && iterator2.hasNext()) {
                Symbol symbol2;
                Symbol symbol1 = iterator1.next();
                int comparison = symbol1.compareTo(symbol2 = iterator2.next());
                if (comparison == 0) continue;
                return comparison;
            }
            if (iterator1.hasNext()) {
                return 1;
            }
            if (iterator2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }

    private static class Rewriter
    extends SimplePlanRewriter<PriorityQueue<WindowNode>> {
        private Rewriter() {
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<PriorityQueue<WindowNode>> context) {
            PriorityQueue<WindowNode> windowNodes = context.get();
            PlanNode sourceNode = context.defaultRewrite(node, new PriorityQueue<WindowNode>(new PartitionByComparator()));
            while (windowNodes.peek() != null) {
                WindowNode windowNode = windowNodes.poll();
                sourceNode = new WindowNode(windowNode.getId(), sourceNode, windowNode.getSpecification(), windowNode.getWindowFunctions(), windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix());
            }
            return sourceNode;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<PriorityQueue<WindowNode>> context) {
            Preconditions.checkState((!node.getHashSymbol().isPresent() ? 1 : 0) != 0, (Object)"ReorderWindows should be run before HashGenerationOptimizer");
            Preconditions.checkState((node.getPrePartitionedInputs().isEmpty() && node.getPreSortedOrderPrefix() == 0 ? 1 : 0) != 0, (Object)"ReorderWindows should be run before AddExchanges");
            context.get().add(node);
            return context.rewrite(node.getSource(), context.get());
        }
    }
}

