/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.EffectivePredicateExtractor;
import com.facebook.presto.sql.planner.EqualityInference;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.ExpressionEquivalence;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.ComparisonExpressionType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.maps.IdentityLinkedHashMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PredicatePushDown
implements PlanOptimizer {
    private static final Logger log = Logger.get(PredicatePushDown.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public PredicatePushDown(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(symbolAllocator, idAllocator, this.metadata, this.sqlParser, session, types), plan, BooleanLiteral.TRUE_LITERAL);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Expression> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final Session session;
        private final Map<Symbol, Type> types;
        private final ExpressionEquivalence expressionEquivalence;

        private Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, Session session, Map<Symbol, Type> types) {
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.expressionEquivalence = new ExpressionEquivalence(metadata, sqlParser);
        }

        @Override
        public PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            PlanNode rewrittenNode = context.defaultRewrite(node, (Expression)BooleanLiteral.TRUE_LITERAL);
            if (!context.get().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, context.get());
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitExchange(ExchangeNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                HashMap<Symbol, SymbolReference> outputsToInputs = new HashMap<Symbol, SymbolReference>();
                for (int index = 0; index < node.getInputs().get(i).size(); ++index) {
                    outputsToInputs.put(node.getOutputSymbols().get(index), node.getInputs().get(i).get(index).toSymbolReference());
                }
                Expression sourcePredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(outputsToInputs), (Expression)context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new ExchangeNode(node.getId(), node.getType(), node.getScope(), node.getPartitioningScheme(), (List<PlanNode>)builder.build(), node.getInputs());
            }
            return node;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set deterministicSymbols = node.getAssignments().entrySet().stream().filter(entry -> DeterminismEvaluator.isDeterministic((Expression)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            Predicate<Expression> deterministic = conjunct -> DependencyExtractor.extractUnique(conjunct).stream().allMatch(deterministicSymbols::contains);
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(deterministic));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.getAssignments().getMap()), (Expression)ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitGroupId(GroupIdNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Preconditions.checkState((!DependencyExtractor.extractUnique(context.get()).contains(node.getGroupIdSymbol()) ? 1 : 0) != 0, (Object)"groupId symbol cannot be referenced in predicate");
            Map<Symbol, SymbolReference> commonGroupingSymbolMapping = node.getGroupingSetMappings().entrySet().stream().filter(entry -> node.getCommonGroupingColumns().contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Symbol)entry.getValue()).toSymbolReference()));
            Predicate<Expression> pushdownEligiblePredicate = conjunct -> DependencyExtractor.extractUnique(conjunct).stream().allMatch(commonGroupingSymbolMapping.keySet()::contains);
            Map<Boolean, List<Expression>> conjuncts = ExpressionUtils.extractConjuncts(context.get()).stream().collect(Collectors.partitioningBy(pushdownEligiblePredicate));
            PlanNode rewrittenNode = context.defaultRewrite(node, ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(commonGroupingSymbolMapping), (Expression)ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(true))));
            if (!conjuncts.get(false).isEmpty()) {
                rewrittenNode = new FilterNode(this.idAllocator.getNextId(), rewrittenNode, ExpressionUtils.combineConjuncts((Collection<Expression>)conjuncts.get(false)));
            }
            return rewrittenNode;
        }

        @Override
        public PlanNode visitMarkDistinct(MarkDistinctNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Preconditions.checkState((!DependencyExtractor.extractUnique(context.get()).contains(node.getMarkerSymbol()) ? 1 : 0) != 0, (Object)"predicate depends on marker symbol");
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitSort(SortNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitUnion(UnionNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            boolean modified = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                Expression sourcePredicate = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(node.sourceSymbolMap(i)), (Expression)context.get());
                PlanNode source = node.getSources().get(i);
                PlanNode rewrittenSource = context.rewrite(source, sourcePredicate);
                if (rewrittenSource != source) {
                    modified = true;
                }
                builder.add((Object)rewrittenSource);
            }
            if (modified) {
                return new UnionNode(node.getId(), (List<PlanNode>)builder.build(), node.getSymbolMapping(), node.getOutputSymbols());
            }
            return node;
        }

        @Override
        @Deprecated
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(node.getPredicate(), context.get()));
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression newJoinPredicate;
            Expression postJoinPredicate;
            BooleanLiteral rightPredicate;
            BooleanLiteral leftPredicate;
            Expression inheritedPredicate = context.get();
            node = this.tryNormalizeToOuterToInnerJoin(node, inheritedPredicate);
            Expression leftEffectivePredicate = EffectivePredicateExtractor.extract(node.getLeft(), this.symbolAllocator.getTypes());
            Expression rightEffectivePredicate = EffectivePredicateExtractor.extract(node.getRight(), this.symbolAllocator.getTypes());
            Expression joinPredicate = Rewriter.extractJoinPredicate(node);
            switch (node.getType()) {
                case INNER: {
                    InnerJoinPushDownResult innerJoinPushDownResult = Rewriter.processInnerJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = innerJoinPushDownResult.getLeftPredicate();
                    rightPredicate = innerJoinPushDownResult.getRightPredicate();
                    postJoinPredicate = innerJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = innerJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case LEFT: {
                    OuterJoinPushDownResult leftOuterJoinPushDownResult = Rewriter.processLimitedOuterJoin(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate, node.getLeft().getOutputSymbols());
                    leftPredicate = leftOuterJoinPushDownResult.getOuterJoinPredicate();
                    rightPredicate = leftOuterJoinPushDownResult.getInnerJoinPredicate();
                    postJoinPredicate = leftOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = leftOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case RIGHT: {
                    OuterJoinPushDownResult rightOuterJoinPushDownResult = Rewriter.processLimitedOuterJoin(inheritedPredicate, rightEffectivePredicate, leftEffectivePredicate, joinPredicate, node.getRight().getOutputSymbols());
                    leftPredicate = rightOuterJoinPushDownResult.getInnerJoinPredicate();
                    rightPredicate = rightOuterJoinPushDownResult.getOuterJoinPredicate();
                    postJoinPredicate = rightOuterJoinPushDownResult.getPostJoinPredicate();
                    newJoinPredicate = rightOuterJoinPushDownResult.getJoinPredicate();
                    break;
                }
                case FULL: {
                    leftPredicate = BooleanLiteral.TRUE_LITERAL;
                    rightPredicate = BooleanLiteral.TRUE_LITERAL;
                    postJoinPredicate = inheritedPredicate;
                    newJoinPredicate = joinPredicate;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
                }
            }
            newJoinPredicate = this.simplifyExpression(newJoinPredicate);
            if (newJoinPredicate.equals((Object)BooleanLiteral.FALSE_LITERAL)) {
                newJoinPredicate = new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("1"));
            }
            PlanNode leftSource = context.rewrite(node.getLeft(), (Expression)leftPredicate);
            PlanNode rightSource = context.rewrite(node.getRight(), (Expression)rightPredicate);
            PlanNode output = node;
            if (leftSource != node.getLeft() || rightSource != node.getRight() || !this.expressionEquivalence.areExpressionsEquivalent(this.session, newJoinPredicate, joinPredicate, this.types)) {
                Assignments.Builder leftProjections = Assignments.builder();
                leftProjections.putAll(node.getLeft().getOutputSymbols().stream().collect(Collectors.toMap(key -> key, Symbol::toSymbolReference)));
                Assignments.Builder rightProjections = Assignments.builder();
                rightProjections.putAll(node.getRight().getOutputSymbols().stream().collect(Collectors.toMap(key -> key, Symbol::toSymbolReference)));
                ImmutableList.Builder joinConditionBuilder = ImmutableList.builder();
                ImmutableList.Builder joinFilterBuilder = ImmutableList.builder();
                for (Expression conjunct : ExpressionUtils.extractConjuncts(newJoinPredicate)) {
                    if (Rewriter.joinEqualityExpression(node.getLeft().getOutputSymbols()).test(conjunct)) {
                        ComparisonExpression equality = (ComparisonExpression)conjunct;
                        boolean alignedComparison = Iterables.all(DependencyExtractor.extractUnique(equality.getLeft()), (com.google.common.base.Predicate)Predicates.in(node.getLeft().getOutputSymbols()));
                        Expression leftExpression = alignedComparison ? equality.getLeft() : equality.getRight();
                        Expression rightExpression = alignedComparison ? equality.getRight() : equality.getLeft();
                        Symbol leftSymbol = this.symbolForExpression(leftExpression);
                        if (!node.getLeft().getOutputSymbols().contains(leftSymbol)) {
                            leftProjections.put(leftSymbol, leftExpression);
                        }
                        Symbol rightSymbol = this.symbolForExpression(rightExpression);
                        if (!node.getRight().getOutputSymbols().contains(rightSymbol)) {
                            rightProjections.put(rightSymbol, rightExpression);
                        }
                        joinConditionBuilder.add((Object)new JoinNode.EquiJoinClause(leftSymbol, rightSymbol));
                        continue;
                    }
                    joinFilterBuilder.add((Object)conjunct);
                }
                Optional<Object> newJoinFilter = Optional.of(ExpressionUtils.combineConjuncts((Collection<Expression>)joinFilterBuilder.build()));
                if (newJoinFilter.get() == BooleanLiteral.TRUE_LITERAL) {
                    newJoinFilter = Optional.empty();
                }
                leftSource = new ProjectNode(this.idAllocator.getNextId(), leftSource, leftProjections.build());
                rightSource = new ProjectNode(this.idAllocator.getNextId(), rightSource, rightProjections.build());
                output = Rewriter.createJoinNodeWithExpectedOutputs(node.getOutputSymbols(), this.idAllocator, node.getType(), leftSource, rightSource, newJoinFilter, (List<JoinNode.EquiJoinClause>)joinConditionBuilder.build(), node.getLeftHashSymbol(), node.getRightHashSymbol());
            }
            if (!postJoinPredicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                output = new FilterNode(this.idAllocator.getNextId(), output, postJoinPredicate);
            }
            return output;
        }

        private Symbol symbolForExpression(Expression expression) {
            if (expression instanceof SymbolReference) {
                return Symbol.from(expression);
            }
            return this.symbolAllocator.newSymbol(expression, this.extractType(expression));
        }

        private static PlanNode createJoinNodeWithExpectedOutputs(List<Symbol> expectedOutputs, PlanNodeIdAllocator idAllocator, JoinNode.Type type, PlanNode left, PlanNode right, Optional<Expression> filter, List<JoinNode.EquiJoinClause> conditions, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol) {
            if (conditions.isEmpty() && !filter.isPresent()) {
                PlanNode output = new JoinNode(idAllocator.getNextId(), type, left, right, conditions, (List<Symbol>)ImmutableList.builder().addAll(left.getOutputSymbols()).addAll(right.getOutputSymbols()).build(), filter, leftHashSymbol, rightHashSymbol);
                if (!((PlanNode)output).getOutputSymbols().equals(expectedOutputs)) {
                    output = new ProjectNode(idAllocator.getNextId(), output, Assignments.identity(expectedOutputs));
                }
                return output;
            }
            return new JoinNode(idAllocator.getNextId(), type, left, right, conditions, expectedOutputs, filter, leftHashSymbol, rightHashSymbol);
        }

        private static OuterJoinPushDownResult processLimitedOuterJoin(Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols) {
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(outerEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(outerSymbols)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(innerEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols))), (Object)"innerEffectivePredicate must not contain symbols from outerSymbols");
            ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
            ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            postJoinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            outerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(outerEffectivePredicate);
            innerEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(innerEffectivePredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            EqualityInference outerInference = EqualityInference.createEqualityInference(inheritedPredicate, outerEffectivePredicate);
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(outerSymbols));
            Expression outerOnlyInheritedEqualities = ExpressionUtils.combineConjuncts(equalityPartition.getScopeEqualities());
            EqualityInference potentialNullSymbolInference = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression outerRewritten = outerInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(outerSymbols));
                if (outerRewritten != null) {
                    outerPushdownConjuncts.add((Object)outerRewritten);
                    Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(outerRewritten, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
                    if (innerRewritten == null) continue;
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                postJoinConjuncts.add((Object)conjunct);
            }
            outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(outerEffectivePredicate)) {
                Expression rewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
                if (rewritten == null) continue;
                innerPushdownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression innerRewritten = potentialNullSymbolInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
                if (innerRewritten != null) {
                    innerPushdownConjuncts.add((Object)innerRewritten);
                    continue;
                }
                joinConjuncts.add((Object)conjunct);
            }
            EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = EqualityInference.createEqualityInference(outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
            innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols))).getScopeEqualities());
            EqualityInference.EqualityPartition joinEqualityPartition = EqualityInference.createEqualityInference(joinPredicate).generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(outerSymbols)));
            innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
            joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
            return new OuterJoinPushDownResult(ExpressionUtils.combineConjuncts((Collection<Expression>)outerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)innerPushdownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)postJoinConjuncts.build()));
        }

        private static InnerJoinPushDownResult processInnerJoin(Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols) {
            Expression rewritten;
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(leftEffectivePredicate), (com.google.common.base.Predicate)Predicates.in(leftSymbols)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
            Preconditions.checkArgument((boolean)Iterables.all(DependencyExtractor.extractUnique(rightEffectivePredicate), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols))), (Object)"rightEffectivePredicate must not contain symbols from leftSymbols");
            ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
            ImmutableList.Builder joinConjuncts = ImmutableList.builder();
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            joinConjuncts.addAll(Iterables.filter(ExpressionUtils.extractConjuncts(joinPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic)));
            joinPredicate = ExpressionUtils.stripNonDeterministicConjuncts(joinPredicate);
            leftEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(leftEffectivePredicate);
            rightEffectivePredicate = ExpressionUtils.stripNonDeterministicConjuncts(rightEffectivePredicate);
            EqualityInference allInference = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutLeftInferred = EqualityInference.createEqualityInference(inheritedPredicate, rightEffectivePredicate, joinPredicate);
            EqualityInference allInferenceWithoutRightInferred = EqualityInference.createEqualityInference(inheritedPredicate, leftEffectivePredicate, joinPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rightRewrittenConjunct;
                Expression leftRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewrittenConjunct != null) {
                    leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
                }
                if ((rightRewrittenConjunct = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
                }
                if (leftRewrittenConjunct != null || rightRewrittenConjunct != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(rightEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (rewritten == null) continue;
                leftPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(leftEffectivePredicate)) {
                rewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)));
                if (rewritten == null) continue;
                rightPushDownConjuncts.add((Object)rewritten);
            }
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(joinPredicate)) {
                Expression rightRewritten;
                Expression leftRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols));
                if (leftRewritten != null) {
                    leftPushDownConjuncts.add((Object)leftRewritten);
                }
                if ((rightRewritten = allInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols)))) != null) {
                    rightPushDownConjuncts.add((Object)rightRewritten);
                }
                if (leftRewritten != null || rightRewritten != null) continue;
                joinConjuncts.add((Object)conjunct);
            }
            leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeEqualities());
            rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.not((com.google.common.base.Predicate)Predicates.in(leftSymbols))).getScopeEqualities());
            joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(leftSymbols)).getScopeStraddlingEqualities());
            return new InnerJoinPushDownResult(ExpressionUtils.combineConjuncts((Collection<Expression>)leftPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)rightPushDownConjuncts.build()), ExpressionUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        private static Expression extractJoinPredicate(JoinNode joinNode) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
                builder.add((Object)Rewriter.equalsExpression(equiJoinClause.getLeft(), equiJoinClause.getRight()));
            }
            joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return ExpressionUtils.combineConjuncts((Collection<Expression>)builder.build());
        }

        private static Expression equalsExpression(Symbol symbol1, Symbol symbol2) {
            return new ComparisonExpression(ComparisonExpressionType.EQUAL, (Expression)symbol1.toSymbolReference(), (Expression)symbol2.toSymbolReference());
        }

        private Type extractType(Expression expression) {
            return ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression, Collections.emptyList()).get(expression);
        }

        private JoinNode tryNormalizeToOuterToInnerJoin(JoinNode node, Expression inheritedPredicate) {
            Preconditions.checkArgument((boolean)EnumSet.of(JoinNode.Type.INNER, JoinNode.Type.RIGHT, JoinNode.Type.LEFT, JoinNode.Type.FULL).contains((Object)node.getType()), (String)"Unsupported join type: %s", (Object)((Object)node.getType()));
            if (node.getType() == JoinNode.Type.INNER) {
                return node;
            }
            if (node.getType() == JoinNode.Type.FULL) {
                boolean canConvertToLeftJoin = this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate);
                boolean canConvertToRightJoin = this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate);
                if (!canConvertToLeftJoin && !canConvertToRightJoin) {
                    return node;
                }
                if (canConvertToLeftJoin && canConvertToRightJoin) {
                    return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol());
                }
                return new JoinNode(node.getId(), canConvertToLeftJoin ? JoinNode.Type.LEFT : JoinNode.Type.RIGHT, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol());
            }
            if (node.getType() == JoinNode.Type.LEFT && !this.canConvertOuterToInner(node.getRight().getOutputSymbols(), inheritedPredicate) || node.getType() == JoinNode.Type.RIGHT && !this.canConvertOuterToInner(node.getLeft().getOutputSymbols(), inheritedPredicate)) {
                return node;
            }
            return new JoinNode(node.getId(), JoinNode.Type.INNER, node.getLeft(), node.getRight(), node.getCriteria(), node.getOutputSymbols(), node.getFilter(), node.getLeftHashSymbol(), node.getRightHashSymbol());
        }

        private boolean canConvertOuterToInner(List<Symbol> innerSymbolsForOuterJoin, Expression inheritedPredicate) {
            ImmutableSet innerSymbols = ImmutableSet.copyOf(innerSymbolsForOuterJoin);
            for (Expression conjunct : ExpressionUtils.extractConjuncts(inheritedPredicate)) {
                Object response;
                if (!DeterminismEvaluator.isDeterministic(conjunct) || (response = this.nullInputEvaluator((Collection<Symbol>)innerSymbols, conjunct)) != null && !(response instanceof NullLiteral) && !Boolean.FALSE.equals(response)) continue;
                return true;
            }
            return false;
        }

        private Expression simplifyExpression(Expression expression) {
            IdentityLinkedHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression, Collections.emptyList());
            ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes);
            return LiteralInterpreter.toExpression(optimizer.optimize(NoOpSymbolResolver.INSTANCE), expressionTypes.get(expression));
        }

        private Object nullInputEvaluator(Collection<Symbol> nullSymbols, Expression expression) {
            IdentityLinkedHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.symbolAllocator.getTypes(), expression, Collections.emptyList());
            return ExpressionInterpreter.expressionOptimizer(expression, this.metadata, this.session, expressionTypes).optimize(symbol -> nullSymbols.contains(symbol) ? null : symbol.toSymbolReference());
        }

        private static Predicate<Expression> joinEqualityExpression(Collection<Symbol> leftSymbols) {
            return expression -> {
                ComparisonExpression comparison;
                if (DeterminismEvaluator.isDeterministic(expression) && expression instanceof ComparisonExpression && (comparison = (ComparisonExpression)expression).getType() == ComparisonExpressionType.EQUAL) {
                    Set<Symbol> symbols1 = DependencyExtractor.extractUnique(comparison.getLeft());
                    Set<Symbol> symbols2 = DependencyExtractor.extractUnique(comparison.getRight());
                    if (symbols1.isEmpty() || symbols2.isEmpty()) {
                        return false;
                    }
                    return Iterables.all(symbols1, (com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols2, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols))) || Iterables.all(symbols2, (com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)) && Iterables.all(symbols1, (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in((Collection)leftSymbols)));
                }
                return false;
            };
        }

        @Override
        public PlanNode visitSemiJoin(SemiJoinNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            Expression sourceEffectivePredicate = EffectivePredicateExtractor.extract(node.getSource(), this.symbolAllocator.getTypes());
            ArrayList<Expression> sourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> filteringSourceConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postJoinConjuncts = new ArrayList<Expression>();
            Expression joinPredicate = Rewriter.equalsExpression(node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol());
            EqualityInference joinInference = EqualityInference.createEqualityInference(inheritedPredicate, sourceEffectivePredicate, joinPredicate);
            for (Expression conjunct : Iterables.concat(EqualityInference.nonInferrableConjuncts(inheritedPredicate), EqualityInference.nonInferrableConjuncts(sourceEffectivePredicate))) {
                Expression rewrittenConjunct = joinInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
                if (rewrittenConjunct == null || !DeterminismEvaluator.isDeterministic(rewrittenConjunct)) continue;
                Expression rewrittenConjunctOrNull = ExpressionUtils.expressionOrNullSymbols(Predicate.isEqual(node.getFilteringSourceJoinSymbol())).apply(rewrittenConjunct);
                filteringSourceConjuncts.add(rewrittenConjunctOrNull);
            }
            EqualityInference.EqualityPartition joinInferenceEqualityPartition = joinInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.equalTo((Object)node.getFilteringSourceJoinSymbol()));
            filteringSourceConjuncts.addAll(joinInferenceEqualityPartition.getScopeEqualities().stream().map(ExpressionUtils.expressionOrNullSymbols(Predicate.isEqual(node.getFilteringSourceJoinSymbol()))).collect(Collectors.toList()));
            EqualityInference inheritedInference = EqualityInference.createEqualityInference(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = inheritedInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
                if (rewrittenConjunct != null) {
                    sourceConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postJoinConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getSource().getOutputSymbols()));
            sourceConjuncts.addAll(equalityPartition.getScopeEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(sourceConjuncts));
            PlanNode rewrittenFilteringSource = context.rewrite(node.getFilteringSource(), ExpressionUtils.combineConjuncts(filteringSourceConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource() || rewrittenFilteringSource != node.getFilteringSource()) {
                output = new SemiJoinNode(node.getId(), rewrittenSource, rewrittenFilteringSource, node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol());
            }
            if (!postJoinConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postJoinConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            if (node.getGroupingKeys().isEmpty()) {
                return this.visitPlan((PlanNode)node, context);
            }
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postAggregationConjuncts = new ArrayList<Expression>();
            postAggregationConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getGroupingKeys()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postAggregationConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getGroupingKeys()));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postAggregationConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new AggregationNode(node.getId(), rewrittenSource, node.getAggregations(), node.getFunctions(), node.getMasks(), node.getGroupingSets(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol());
            }
            if (!postAggregationConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postAggregationConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression inheritedPredicate = context.get();
            EqualityInference equalityInference = EqualityInference.createEqualityInference(inheritedPredicate);
            ArrayList<Expression> pushdownConjuncts = new ArrayList<Expression>();
            ArrayList<Expression> postUnnestConjuncts = new ArrayList<Expression>();
            postUnnestConjuncts.addAll((Collection<Expression>)ImmutableList.copyOf((Iterable)Iterables.filter(ExpressionUtils.extractConjuncts(inheritedPredicate), (com.google.common.base.Predicate)Predicates.not(DeterminismEvaluator::isDeterministic))));
            inheritedPredicate = ExpressionUtils.stripNonDeterministicConjuncts(inheritedPredicate);
            for (Expression conjunct : EqualityInference.nonInferrableConjuncts(inheritedPredicate)) {
                Expression rewrittenConjunct = equalityInference.rewriteExpression(conjunct, (com.google.common.base.Predicate<Symbol>)Predicates.in(node.getReplicateSymbols()));
                if (rewrittenConjunct != null) {
                    pushdownConjuncts.add(rewrittenConjunct);
                    continue;
                }
                postUnnestConjuncts.add(conjunct);
            }
            EqualityInference.EqualityPartition equalityPartition = equalityInference.generateEqualitiesPartitionedBy((com.google.common.base.Predicate<Symbol>)Predicates.in(node.getReplicateSymbols()));
            pushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
            postUnnestConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
            PlanNode rewrittenSource = context.rewrite(node.getSource(), ExpressionUtils.combineConjuncts(pushdownConjuncts));
            PlanNode output = node;
            if (rewrittenSource != node.getSource()) {
                output = new UnnestNode(node.getId(), rewrittenSource, node.getReplicateSymbols(), node.getUnnestSymbols(), node.getOrdinalitySymbol());
            }
            if (!postUnnestConjuncts.isEmpty()) {
                output = new FilterNode(this.idAllocator.getNextId(), output, ExpressionUtils.combineConjuncts(postUnnestConjuncts));
            }
            return output;
        }

        @Override
        public PlanNode visitSample(SampleNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Expression predicate = this.simplifyExpression(context.get());
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)predicate)) {
                return new FilterNode(this.idAllocator.getNextId(), node, predicate);
            }
            return node;
        }

        @Override
        public PlanNode visitAssignUniqueId(AssignUniqueId node, SimplePlanRewriter.RewriteContext<Expression> context) {
            Set<Symbol> predicateSymbols = DependencyExtractor.extractUnique(context.get());
            Preconditions.checkState((!predicateSymbols.contains(node.getIdColumn()) ? 1 : 0) != 0, (Object)"UniqueId in predicate is not yet supported");
            return context.defaultRewrite(node, context.get());
        }

        private static class InnerJoinPushDownResult {
            private final Expression leftPredicate;
            private final Expression rightPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.leftPredicate = leftPredicate;
                this.rightPredicate = rightPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getLeftPredicate() {
                return this.leftPredicate;
            }

            private Expression getRightPredicate() {
                return this.rightPredicate;
            }

            private Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }

        private static class OuterJoinPushDownResult {
            private final Expression outerJoinPredicate;
            private final Expression innerJoinPredicate;
            private final Expression joinPredicate;
            private final Expression postJoinPredicate;

            private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression joinPredicate, Expression postJoinPredicate) {
                this.outerJoinPredicate = outerJoinPredicate;
                this.innerJoinPredicate = innerJoinPredicate;
                this.joinPredicate = joinPredicate;
                this.postJoinPredicate = postJoinPredicate;
            }

            private Expression getOuterJoinPredicate() {
                return this.outerJoinPredicate;
            }

            private Expression getInnerJoinPredicate() {
                return this.innerJoinPredicate;
            }

            public Expression getJoinPredicate() {
                return this.joinPredicate;
            }

            private Expression getPostJoinPredicate() {
                return this.postJoinPredicate;
            }
        }
    }
}

