/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;

public class RemoveRedundantIdentityProjections
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof ProjectNode)) {
            return Optional.empty();
        }
        ProjectNode project = (ProjectNode)node;
        if (!project.isIdentity()) {
            return Optional.empty();
        }
        if (!ImmutableSet.copyOf(project.getOutputSymbols()).equals((Object)ImmutableSet.copyOf(project.getSource().getOutputSymbols()))) {
            return Optional.empty();
        }
        return Optional.of(project.getSource());
    }
}

