/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PruneValuesColumns
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof ProjectNode)) {
            return Optional.empty();
        }
        ProjectNode parent = (ProjectNode)node;
        PlanNode child = lookup.resolve(parent.getSource());
        if (!(child instanceof ValuesNode)) {
            return Optional.empty();
        }
        ValuesNode values = (ValuesNode)child;
        Optional<List<Symbol>> dependencies = Util.pruneInputs(child.getOutputSymbols(), parent.getAssignments().getExpressions());
        if (!dependencies.isPresent()) {
            return Optional.empty();
        }
        List<Symbol> newOutputs = dependencies.get();
        int[] mapping = new int[newOutputs.size()];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = values.getOutputSymbols().indexOf(newOutputs.get(i));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (List<Expression> row : values.getRows()) {
            rowsBuilder.add(Arrays.stream(mapping).mapToObj(row::get).collect(Collectors.toList()));
        }
        return Optional.of(new ProjectNode(parent.getId(), new ValuesNode(values.getId(), newOutputs, (List<List<Expression>>)rowsBuilder.build()), parent.getAssignments()));
    }
}

