/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Optional;

public class MergeFilters
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof FilterNode)) {
            return Optional.empty();
        }
        FilterNode parent = (FilterNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof FilterNode)) {
            return Optional.empty();
        }
        FilterNode child = (FilterNode)source;
        return Optional.of(new FilterNode(parent.getId(), child.getSource(), ExpressionUtils.combineConjuncts(child.getPredicate(), parent.getPredicate())));
    }
}

