/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolExtractor;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class PlanFragmenter {
    private PlanFragmenter() {
    }

    public static SubPlan createSubPlans(Session session, Metadata metadata, Plan plan) {
        Fragmenter fragmenter = new Fragmenter(session, metadata, plan.getSymbolAllocator().getTypes());
        FragmentProperties properties = new FragmentProperties(new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getRoot().getOutputSymbols())).setSingleNodeDistribution();
        PlanNode root = SimplePlanRewriter.rewriteWith(fragmenter, plan.getRoot(), properties);
        SubPlan result = fragmenter.buildRootFragment(root, properties);
        Preconditions.checkState((boolean)result.getFragment().getPartitioning().isSingleNode(), (Object)"Root of PlanFragment is not single node");
        result.sanityCheck();
        return result;
    }

    private static class SchedulingOrderVisitor
    extends PlanVisitor<Consumer<PlanNodeId>, Void> {
        private SchedulingOrderVisitor() {
        }

        public List<PlanNodeId> getSchedulingOrder(PlanNode node) {
            ImmutableList.Builder schedulingOrder = ImmutableList.builder();
            node.accept(this, arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0));
            return schedulingOrder.build();
        }

        @Override
        protected Void visitPlan(PlanNode node, Consumer<PlanNodeId> schedulingOrder) {
            for (PlanNode source : node.getSources()) {
                source.accept(this, schedulingOrder);
            }
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getRight().accept(this, schedulingOrder);
            node.getLeft().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getFilteringSource().accept(this, schedulingOrder);
            node.getSource().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Consumer<PlanNodeId> schedulingOrder) {
            node.getIndexSource().accept(this, schedulingOrder);
            node.getProbeSource().accept(this, schedulingOrder);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Consumer<PlanNodeId> schedulingOrder) {
            schedulingOrder.accept(node.getId());
            return null;
        }
    }

    private static class FragmentProperties {
        private final List<SubPlan> children = new ArrayList<SubPlan>();
        private final PartitioningScheme partitioningScheme;
        private Optional<PartitioningHandle> partitioningHandle = Optional.empty();
        private final Set<PlanNodeId> partitionedSources = new HashSet<PlanNodeId>();

        public FragmentProperties(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
        }

        public List<SubPlan> getChildren() {
            return this.children;
        }

        public FragmentProperties setSingleNodeDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isSingleNode()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.SINGLE_DISTRIBUTION);
            return this;
        }

        public FragmentProperties setDistribution(PartitioningHandle distribution) {
            if (this.partitioningHandle.isPresent() && !this.partitioningHandle.get().equals(distribution) && !this.partitioningHandle.get().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
                Preconditions.checkState((boolean)this.partitioningHandle.get().isSingleNode(), (String)"Cannot set distribution to %s. Already set to %s", (Object)distribution, this.partitioningHandle);
                return this;
            }
            this.partitioningHandle = Optional.of(distribution);
            return this;
        }

        public FragmentProperties setCoordinatorOnlyDistribution() {
            if (this.partitioningHandle.isPresent() && this.partitioningHandle.get().isCoordinatorOnly()) {
                return this;
            }
            Preconditions.checkState((!this.partitioningHandle.isPresent() || this.partitioningHandle.get().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite partitioning with %s (currently set to %s)", (Object)SystemPartitioningHandle.COORDINATOR_DISTRIBUTION, this.partitioningHandle);
            this.partitioningHandle = Optional.of(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION);
            return this;
        }

        public FragmentProperties addSourceDistribution(PlanNodeId source, PartitioningHandle distribution) {
            PartitioningHandle currentPartitioning;
            Objects.requireNonNull(source, "source is null");
            Objects.requireNonNull(distribution, "distribution is null");
            this.partitionedSources.add(source);
            if (this.partitioningHandle.isPresent() && !(currentPartitioning = this.partitioningHandle.get()).equals(distribution)) {
                Preconditions.checkState((currentPartitioning.equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || currentPartitioning.equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION) ? 1 : 0) != 0, (String)"Cannot overwrite distribution with %s (currently set to %s)", (Object)distribution, (Object)currentPartitioning);
                return this;
            }
            this.partitioningHandle = Optional.of(distribution);
            return this;
        }

        public FragmentProperties addChildren(List<SubPlan> children) {
            this.children.addAll(children);
            return this;
        }

        public PartitioningScheme getPartitioningScheme() {
            return this.partitioningScheme;
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle.get();
        }

        public Set<PlanNodeId> getPartitionedSources() {
            return this.partitionedSources;
        }
    }

    private static class Fragmenter
    extends SimplePlanRewriter<FragmentProperties> {
        private static final int ROOT_FRAGMENT_ID = 0;
        private final Session session;
        private final Metadata metadata;
        private final Map<Symbol, Type> types;
        private int nextFragmentId = 1;

        public Fragmenter(Session session, Metadata metadata, Map<Symbol, Type> types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
        }

        public SubPlan buildRootFragment(PlanNode root, FragmentProperties properties) {
            return this.buildFragment(root, properties, new PlanFragmentId(String.valueOf(0)));
        }

        private PlanFragmentId nextFragmentId() {
            return new PlanFragmentId(String.valueOf(this.nextFragmentId++));
        }

        private SubPlan buildFragment(PlanNode root, FragmentProperties properties, PlanFragmentId fragmentId) {
            Set<Symbol> dependencies = SymbolExtractor.extract(root);
            List<PlanNodeId> schedulingOrder = new SchedulingOrderVisitor().getSchedulingOrder(root);
            boolean equals = properties.getPartitionedSources().equals(ImmutableSet.copyOf(schedulingOrder));
            Preconditions.checkArgument((boolean)equals, (String)"Expected scheduling order (%s) to contain an entry for all partitioned sources (%s)", schedulingOrder, properties.getPartitionedSources());
            PlanFragment fragment = new PlanFragment(fragmentId, root, Maps.filterKeys(this.types, (Predicate)Predicates.in(dependencies)), properties.getPartitioningHandle(), schedulingOrder, properties.getPartitioningScheme());
            return new SubPlan(fragment, properties.getChildren());
        }

        @Override
        public PlanNode visitOutput(OutputNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExplainAnalyze(ExplainAnalyzeNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableFinish(TableFinishNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitMetadataDelete(MetadataDeleteNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setCoordinatorOnlyDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PartitioningHandle partitioning = node.getLayout().map(layout -> this.metadata.getLayout(this.session, (TableLayoutHandle)layout)).flatMap(TableLayout::getNodePartitioning).map(TableLayout.NodePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            context.get().addSourceDistribution(node.getId(), partitioning);
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            context.get().setSingleNodeDistribution();
            return context.defaultRewrite(node, context.get());
        }

        @Override
        public PlanNode visitExchange(ExchangeNode exchange, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            if (exchange.getScope() != ExchangeNode.Scope.REMOTE) {
                return context.defaultRewrite(exchange, context.get());
            }
            PartitioningScheme partitioningScheme = exchange.getPartitioningScheme();
            ImmutableList.Builder builder = ImmutableList.builder();
            if (exchange.getType() == ExchangeNode.Type.GATHER) {
                context.get().setSingleNodeDistribution();
                for (int i = 0; i < exchange.getSources().size(); ++i) {
                    FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout(exchange.getInputs().get(i)));
                    builder.add((Object)this.buildSubPlan(exchange.getSources().get(i), childProperties, context));
                }
            } else if (exchange.getType() == ExchangeNode.Type.REPARTITION) {
                context.get().setDistribution(partitioningScheme.getPartitioning().getHandle());
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs())));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            } else if (exchange.getType() == ExchangeNode.Type.REPLICATE) {
                FragmentProperties childProperties = new FragmentProperties(partitioningScheme.translateOutputLayout((List)Iterables.getOnlyElement(exchange.getInputs())));
                builder.add((Object)this.buildSubPlan((PlanNode)Iterables.getOnlyElement(exchange.getSources()), childProperties, context));
            }
            ImmutableList children = builder.build();
            context.get().addChildren((List<SubPlan>)children);
            List childrenIds = (List)children.stream().map(SubPlan::getFragment).map(PlanFragment::getId).collect(ImmutableCollectors.toImmutableList());
            return new RemoteSourceNode(exchange.getId(), childrenIds, exchange.getOutputSymbols());
        }

        private SubPlan buildSubPlan(PlanNode node, FragmentProperties properties, SimplePlanRewriter.RewriteContext<FragmentProperties> context) {
            PlanFragmentId planFragmentId = this.nextFragmentId();
            PlanNode child = context.rewrite(node, properties);
            return this.buildFragment(child, properties, planFragmentId);
        }
    }
}

