/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final PartitioningHandle partitioning;
    private final List<PlanNodeId> partitionedSources;
    private final Set<PlanNodeId> partitionedSourcesSet;
    private final List<Type> types;
    private final Set<PlanNode> partitionedSourceNodes;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final PartitioningScheme partitioningScheme;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="partitionedSources") List<PlanNodeId> partitionedSources, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.partitionedSources = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedSources, "partitionedSources is null"));
        this.partitionedSourcesSet = ImmutableSet.copyOf(partitionedSources);
        Preconditions.checkArgument((this.partitionedSourcesSet.size() == partitionedSources.size() ? 1 : 0) != 0, (Object)"partitionedSources contains duplicates");
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(partitioningScheme.getOutputLayout()), (String)"Root node outputs (%s) does not include all fragment outputs (%s)", root.getOutputSymbols(), partitioningScheme.getOutputLayout());
        this.types = (List)partitioningScheme.getOutputLayout().stream().map(symbols::get).collect(ImmutableCollectors.toImmutableList());
        this.partitionedSourceNodes = PlanFragment.findSources(root, partitionedSources);
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<PlanNodeId> getPartitionedSources() {
        return this.partitionedSources;
    }

    public boolean isPartitionedSources(PlanNodeId nodeId) {
        return this.partitionedSourcesSet.contains(nodeId);
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Set<PlanNode> getPartitionedSourceNodes() {
        return this.partitionedSourceNodes;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static Set<PlanNode> findSources(PlanNode node, Iterable<PlanNodeId> nodeIds) {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        PlanFragment.findSources(node, (Set<PlanNodeId>)ImmutableSet.copyOf(nodeIds), (ImmutableSet.Builder<PlanNode>)nodes);
        return nodes.build();
    }

    private static void findSources(PlanNode node, Set<PlanNodeId> nodeIds, ImmutableSet.Builder<PlanNode> nodes) {
        if (nodeIds.contains(node.getId())) {
            nodes.add((Object)node);
        }
        node.getSources().stream().flatMap(source -> PlanFragment.findSources(source, nodeIds).stream()).forEach(arg_0 -> nodes.add(arg_0));
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public PlanFragment withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.partitionedSources, this.partitioningScheme.withBucketToPartition(bucketToPartition));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitioning", (Object)this.partitioning).add("partitionedSource", this.partitionedSources).add("partitionFunction", (Object)this.partitioningScheme).toString();
    }
}

