/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Partitioning {
    private final PartitioningHandle handle;
    private final List<ArgumentBinding> arguments;

    private Partitioning(PartitioningHandle handle, List<ArgumentBinding> arguments) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.arguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    public static Partitioning create(PartitioningHandle handle, List<Symbol> columns) {
        return new Partitioning(handle, (List)columns.stream().map(ArgumentBinding::columnBinding).collect(ImmutableCollectors.toImmutableList()));
    }

    @JsonCreator
    public static Partitioning jsonCreate(@JsonProperty(value="handle") PartitioningHandle handle, @JsonProperty(value="arguments") List<ArgumentBinding> arguments) {
        return new Partitioning(handle, arguments);
    }

    @JsonProperty
    public PartitioningHandle getHandle() {
        return this.handle;
    }

    @JsonProperty
    public List<ArgumentBinding> getArguments() {
        return this.arguments;
    }

    public Set<Symbol> getColumns() {
        return (Set)this.arguments.stream().filter(ArgumentBinding::isVariable).map(ArgumentBinding::getColumn).collect(ImmutableCollectors.toImmutableSet());
    }

    public boolean isPartitionedWith(Partitioning right, Function<Symbol, Set<Symbol>> leftToRightMappings, Function<Symbol, Optional<NullableValue>> leftConstantMapping, Function<Symbol, Optional<NullableValue>> rightConstantMapping) {
        if (!this.handle.equals(right.handle)) {
            return false;
        }
        if (this.arguments.size() != right.arguments.size()) {
            return false;
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            ArgumentBinding rightArgument;
            ArgumentBinding leftArgument = this.arguments.get(i);
            if (Partitioning.isPartitionedWith(leftArgument, leftConstantMapping, rightArgument = right.arguments.get(i), rightConstantMapping, leftToRightMappings)) continue;
            return false;
        }
        return true;
    }

    private static boolean isPartitionedWith(ArgumentBinding leftArgument, Function<Symbol, Optional<NullableValue>> leftConstantMapping, ArgumentBinding rightArgument, Function<Symbol, Optional<NullableValue>> rightConstantMapping, Function<Symbol, Set<Symbol>> leftToRightMappings) {
        if (leftArgument.isVariable()) {
            if (rightArgument.isVariable()) {
                Set<Symbol> mappedColumns = leftToRightMappings.apply(leftArgument.getColumn());
                return mappedColumns.contains(rightArgument.getColumn());
            }
            Optional<NullableValue> leftConstant = leftConstantMapping.apply(leftArgument.getColumn());
            return leftConstant.isPresent() && leftConstant.get().equals((Object)rightArgument.getConstant());
        }
        if (rightArgument.isConstant()) {
            return leftArgument.getConstant().equals((Object)rightArgument.getConstant());
        }
        Optional<NullableValue> rightConstant = rightConstantMapping.apply(rightArgument.getColumn());
        return rightConstant.isPresent() && rightConstant.get().equals((Object)leftArgument.getConstant());
    }

    public boolean isPartitionedOn(Collection<Symbol> columns, Set<Symbol> knownConstants) {
        return this.arguments.stream().filter(ArgumentBinding::isVariable).map(ArgumentBinding::getColumn).filter(symbol -> !knownConstants.contains(symbol)).allMatch(columns::contains);
    }

    public boolean isEffectivelySinglePartition(Set<Symbol> knownConstants) {
        return this.isPartitionedOn((Collection<Symbol>)ImmutableSet.of(), knownConstants);
    }

    public boolean isRepartitionEffective(Collection<Symbol> keys, Set<Symbol> knownConstants) {
        Set keysWithoutConstants = (Set)keys.stream().filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
        Set nonConstantArgs = (Set)this.arguments.stream().filter(ArgumentBinding::isVariable).map(ArgumentBinding::getColumn).filter(symbol -> !knownConstants.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
        return !nonConstantArgs.equals(keysWithoutConstants);
    }

    public Partitioning translate(Function<Symbol, Symbol> translator) {
        return new Partitioning(this.handle, (List)this.arguments.stream().map(argument -> argument.translate(translator)).collect(ImmutableCollectors.toImmutableList()));
    }

    public Optional<Partitioning> translate(Function<Symbol, Optional<Symbol>> translator, Function<Symbol, Optional<NullableValue>> constants) {
        ImmutableList.Builder newArguments = ImmutableList.builder();
        for (ArgumentBinding argument : this.arguments) {
            Optional<ArgumentBinding> newArgument = argument.translate(translator, constants);
            if (!newArgument.isPresent()) {
                return Optional.empty();
            }
            newArguments.add((Object)newArgument.get());
        }
        return Optional.of(new Partitioning(this.handle, (List<ArgumentBinding>)newArguments.build()));
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partitioning other = (Partitioning)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.arguments, other.arguments);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("handle", (Object)this.handle).add("arguments", this.arguments).toString();
    }

    @Immutable
    public static final class ArgumentBinding {
        private final Symbol column;
        private final NullableValue constant;

        @JsonCreator
        public ArgumentBinding(@JsonProperty(value="column") Symbol column, @JsonProperty(value="constant") NullableValue constant) {
            this.column = column;
            this.constant = constant;
            Preconditions.checkArgument((column == null != (constant == null) ? 1 : 0) != 0, (Object)"Either column or constant must be set");
        }

        public static ArgumentBinding columnBinding(Symbol column) {
            return new ArgumentBinding(Objects.requireNonNull(column, "column is null"), null);
        }

        public static ArgumentBinding constantBinding(NullableValue constant) {
            return new ArgumentBinding(null, Objects.requireNonNull(constant, "constant is null"));
        }

        public boolean isConstant() {
            return this.constant != null;
        }

        public boolean isVariable() {
            return this.column != null;
        }

        @JsonProperty
        public Symbol getColumn() {
            return this.column;
        }

        @JsonProperty
        public NullableValue getConstant() {
            return this.constant;
        }

        public ArgumentBinding translate(Function<Symbol, Symbol> translator) {
            if (this.isConstant()) {
                return this;
            }
            return ArgumentBinding.columnBinding(translator.apply(this.column));
        }

        public Optional<ArgumentBinding> translate(Function<Symbol, Optional<Symbol>> translator, Function<Symbol, Optional<NullableValue>> constants) {
            if (this.isConstant()) {
                return Optional.of(this);
            }
            Optional<ArgumentBinding> newColumn = translator.apply(this.column).map(ArgumentBinding::columnBinding);
            if (newColumn.isPresent()) {
                return newColumn;
            }
            return constants.apply(this.column).map(ArgumentBinding::constantBinding);
        }

        public String toString() {
            if (this.constant != null) {
                return this.constant.toString();
            }
            return "\"" + this.column + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentBinding that = (ArgumentBinding)o;
            return Objects.equals(this.column, that.column) && Objects.equals(this.constant, that.constant);
        }

        public int hashCode() {
            return Objects.hash(this.column, this.constant);
        }
    }
}

