/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class VarArgsToMapAdapterGenerator {
    private VarArgsToMapAdapterGenerator() {
    }

    public static MethodHandle generateVarArgsToMapAdapter(Class<?> returnType, List<Class<?>> javaTypes, List<String> names, Function<Map<String, Object>, Object> function) {
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"VarArgsToMapAdapter"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        ImmutableList.Builder parameterListBuilder = ImmutableList.builder();
        for (int i = 0; i < javaTypes.size(); ++i) {
            Class<?> javaType = javaTypes.get(i);
            parameterListBuilder.add((Object)Parameter.arg((String)("input_" + i), javaType));
        }
        ImmutableList parameterList = parameterListBuilder.build();
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "varArgsToMap", ParameterizedType.type(returnType), (Iterable)parameterList);
        BytecodeBlock body = methodDefinition.getBody();
        Variable map = methodDefinition.getScope().declareVariable(HashMap.class, "map");
        body.append((BytecodeNode)map.set(BytecodeExpressions.invokeStatic(Maps.class, (String)"newHashMapWithExpectedSize", HashMap.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantInt((int)javaTypes.size())})));
        for (int i = 0; i < javaTypes.size(); ++i) {
            body.append((BytecodeNode)map.invoke("put", Object.class, new BytecodeExpression[]{BytecodeExpressions.constantString((String)names.get(i)).cast(Object.class), ((Parameter)parameterList.get(i)).cast(Object.class)}));
        }
        body.append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder, function, Function.class).invoke("apply", Object.class, new BytecodeExpression[]{map.cast(Object.class)}).cast(returnType).ret());
        Class generatedClass = CompilerUtils.defineClass((ClassDefinition)classDefinition, Object.class, callSiteBinder.getBindings(), (ClassLoader)new DynamicClassLoader(VarArgsToMapAdapterGenerator.class.getClassLoader()));
        return Reflection.methodHandle(generatedClass, "varArgsToMap", javaTypes.toArray(new Class[javaTypes.size()]));
    }
}

