/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.TryCatch;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;

public class TryCodeGenerator
implements BytecodeGenerator {
    private static final String EXCEPTION_HANDLER_NAME = "tryExpressionExceptionHandler";
    private final Map<CallExpression, MethodDefinition> tryMethodsMap;

    public TryCodeGenerator(Map<CallExpression, MethodDefinition> tryMethodsMap) {
        this.tryMethodsMap = tryMethodsMap;
    }

    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)"try methods only contain a single expression");
        Preconditions.checkArgument((boolean)(Iterables.getOnlyElement(arguments) instanceof CallExpression), (Object)"try methods must contain a call expression");
        CallExpression innerCallExpression = (CallExpression)Iterables.getOnlyElement(arguments);
        Preconditions.checkState((boolean)this.tryMethodsMap.containsKey(innerCallExpression), (Object)"try methods map does not contain this try call");
        MethodDefinition definition = this.tryMethodsMap.get(innerCallExpression);
        ImmutableList invokeArguments = definition.getParameters().stream().map(parameter -> context.getScope().getVariable(parameter.getName())).collect(ImmutableCollectors.toImmutableList());
        return new BytecodeBlock().append((BytecodeNode)context.getScope().getThis().invoke(definition, invokeArguments)).append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(context.getScope(), Primitives.wrap((Class)innerCallExpression.getType().getJavaType())));
    }

    public static MethodDefinition defineTryMethod(BytecodeExpressionVisitor innerExpressionVisitor, ClassDefinition classDefinition, String methodName, List<Parameter> inputParameters, Class<?> returnType, RowExpression innerRowExpression, CallSiteBinder callSiteBinder) {
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), methodName, ParameterizedType.type(returnType), inputParameters);
        Scope calleeMethodScope = method.getScope();
        Variable wasNull = calleeMethodScope.declareVariable(Boolean.TYPE, "wasNull");
        BytecodeNode innerExpression = innerRowExpression.accept(innerExpressionVisitor, calleeMethodScope);
        MethodType exceptionHandlerType = MethodType.methodType(returnType, PrestoException.class);
        MethodHandle exceptionHandler = Reflection.methodHandle(TryCodeGenerator.class, EXCEPTION_HANDLER_NAME, PrestoException.class).asType(exceptionHandlerType);
        Binding binding = callSiteBinder.bind(exceptionHandler);
        method.comment("Try projection: %s", new Object[]{innerRowExpression.toString()});
        method.getBody().append((BytecodeNode)wasNull.set(BytecodeExpressions.constantBoolean((boolean)false))).append((BytecodeNode)new TryCatch((BytecodeNode)new BytecodeBlock().append(innerExpression).append(BytecodeUtils.boxPrimitiveIfNecessary(calleeMethodScope, returnType)), (BytecodeNode)new BytecodeBlock().append(BytecodeUtils.invoke(binding, EXCEPTION_HANDLER_NAME)), ParameterizedType.type(PrestoException.class))).ret(returnType);
        return method;
    }

    public static Object tryExpressionExceptionHandler(PrestoException e) throws PrestoException {
        int errorCode = e.getErrorCode().getCode();
        if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
            return null;
        }
        throw e;
    }
}

