/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.facebook.presto.sql.relational.RowExpression;
import java.util.List;

public class RowConstructorCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext context, Type rowType, List<RowExpression> arguments) {
        BytecodeBlock block = new BytecodeBlock().setDescription("Constructor for " + rowType.toString());
        CallSiteBinder binder = context.getCallSiteBinder();
        Scope scope = context.getScope();
        List types = rowType.getTypeParameters();
        block.comment("BlockBuilder blockBuilder = new InterleavedBlockBuilder(types, new BlockBuilderStatus(), 1);");
        Variable blockBuilder = scope.createTempVariable(BlockBuilder.class);
        Binding typesBinding = binder.bind(types, List.class);
        block.append((BytecodeNode)blockBuilder.set(BytecodeExpressions.newInstance(InterleavedBlockBuilder.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeUtils.loadConstant(typesBinding), BytecodeExpressions.newInstance(BlockBuilderStatus.class, (BytecodeExpression[])new BytecodeExpression[0]), BytecodeExpressions.constantInt((int)1)})));
        for (int i = 0; i < arguments.size(); ++i) {
            Type fieldType = (Type)types.get(i);
            Class javaType = fieldType.getJavaType();
            if (javaType == Void.TYPE) {
                block.comment(i + "-th field type of row is undefined");
                block.append((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
                continue;
            }
            Variable field = scope.createTempVariable(javaType);
            block.comment("Clean wasNull and Generate + " + i + "-th field of row");
            block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
            block.append(context.generate(arguments.get(i)));
            block.putVariable(field);
            block.append((BytecodeNode)new IfStatement().condition((BytecodeNode)context.wasNull()).ifTrue((BytecodeNode)blockBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(binder, fieldType).writeValue((BytecodeExpression)blockBuilder, (BytecodeExpression)field).pop()));
        }
        block.comment("put (Block) blockBuilder.build(); wasNull = false;");
        block.append((BytecodeNode)blockBuilder.invoke("build", Block.class, new BytecodeExpression[0]));
        block.append((BytecodeNode)context.wasNull().set(BytecodeExpressions.constantFalse()));
        return block;
    }
}

