/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.InternalJoinFilterFunction;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.StandardJoinFilterFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CacheStatsMBean;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.InputReferenceCompiler;
import com.facebook.presto.sql.gen.IsolatedClass;
import com.facebook.presto.sql.gen.LambdaAndTryExpressionExtractor;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.TryCodeGenerator;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JoinFilterFunctionCompiler {
    private final Metadata metadata;
    private final LoadingCache<JoinFilterCacheKey, JoinFilterFunctionFactory> joinFilterFunctionFactories = CacheBuilder.newBuilder().recordStats().maximumSize(1000L).build((CacheLoader)new CacheLoader<JoinFilterCacheKey, JoinFilterFunctionFactory>(){

        public JoinFilterFunctionFactory load(JoinFilterCacheKey key) throws Exception {
            return JoinFilterFunctionCompiler.this.internalCompileFilterFunctionFactory(key.getFilter(), key.getLeftBlocksSize());
        }
    });

    @Inject
    public JoinFilterFunctionCompiler(Metadata metadata) {
        this.metadata = metadata;
    }

    @Managed
    @Nested
    public CacheStatsMBean getJoinFilterFunctionFactoryStats() {
        return new CacheStatsMBean(this.joinFilterFunctionFactories);
    }

    public JoinFilterFunctionFactory compileJoinFilterFunction(RowExpression filter, int leftBlocksSize) {
        return (JoinFilterFunctionFactory)this.joinFilterFunctionFactories.getUnchecked((Object)new JoinFilterCacheKey(filter, leftBlocksSize));
    }

    private JoinFilterFunctionFactory internalCompileFilterFunctionFactory(RowExpression filterExpression, int leftBlocksSize) {
        Class<? extends InternalJoinFilterFunction> internalJoinFilterFunction = this.compileInternalJoinFilterFunction(filterExpression, leftBlocksSize);
        return new IsolatedJoinFilterFunctionFactory(internalJoinFilterFunction);
    }

    private Class<? extends InternalJoinFilterFunction> compileInternalJoinFilterFunction(RowExpression filterExpression, int leftBlocksSize) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)"JoinFilterFunction"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(InternalJoinFilterFunction.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        new JoinFilterFunctionCompiler(this.metadata).generateMethods(classDefinition, callSiteBinder, filterExpression, leftBlocksSize);
        JoinFilterFunctionCompiler.generateToString(classDefinition, callSiteBinder, MoreObjects.toStringHelper((String)classDefinition.getType().getJavaClassName()).add("filter", (Object)filterExpression).add("leftBlocksSize", leftBlocksSize).toString());
        return CompilerUtils.defineClass((ClassDefinition)classDefinition, InternalJoinFilterFunction.class, callSiteBinder.getBindings(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void generateMethods(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, RowExpression filter, int leftBlocksSize) {
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(classDefinition, callSiteBinder);
        FieldDefinition sessionField = classDefinition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.FINAL}), "session", ConnectorSession.class);
        this.generateFilterMethod(classDefinition, callSiteBinder, cachedInstanceBinder, filter, leftBlocksSize, sessionField);
        JoinFilterFunctionCompiler.generateConstructor(classDefinition, sessionField, cachedInstanceBinder);
    }

    private static void generateConstructor(ClassDefinition classDefinition, FieldDefinition sessionField, CachedInstanceBinder cachedInstanceBinder) {
        Parameter sessionParameter = Parameter.arg((String)"session", ConnectorSession.class);
        MethodDefinition constructorDefinition = classDefinition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[]{sessionParameter});
        BytecodeBlock body = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        body.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        body.append((BytecodeNode)thisVariable.setField(sessionField, (BytecodeExpression)sessionParameter));
        cachedInstanceBinder.generateInitializations(thisVariable, body);
        body.ret();
    }

    private void generateFilterMethod(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpression filter, int leftBlocksSize, FieldDefinition sessionField) {
        PreGeneratedExpressions preGeneratedExpressions = this.generateMethodsForLambdaAndTry(classDefinition, callSiteBinder, cachedInstanceBinder, leftBlocksSize, filter);
        Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
        Parameter leftBlocks = Parameter.arg((String)"leftBlocks", Block[].class);
        Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
        Parameter rightBlocks = Parameter.arg((String)"rightBlocks", Block[].class);
        MethodDefinition method = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "filter", ParameterizedType.type(Boolean.TYPE), (Iterable)ImmutableList.builder().add((Object)leftPosition).add((Object)leftBlocks).add((Object)rightPosition).add((Object)rightBlocks).build());
        method.comment("filter: %s", new Object[]{filter.toString()});
        BytecodeBlock body = method.getBody();
        Scope scope = method.getScope();
        Variable wasNullVariable = scope.declareVariable("wasNull", body, BytecodeExpressions.constantFalse());
        scope.declareVariable("session", body, method.getThis().getField(sessionField));
        BytecodeExpressionVisitor visitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, JoinFilterFunctionCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)leftPosition, (Variable)leftBlocks, (Variable)rightPosition, (Variable)rightBlocks, leftBlocksSize), this.metadata.getFunctionRegistry(), preGeneratedExpressions);
        BytecodeNode visitorBody = filter.accept(visitor, scope);
        Variable result = scope.declareVariable(Boolean.TYPE, "result");
        body.append(visitorBody).putVariable(result).append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)BytecodeExpressions.constantFalse().ret()).ifFalse((BytecodeNode)result.ret()));
    }

    private PreGeneratedExpressions generateMethodsForLambdaAndTry(ClassDefinition containerClassDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, int leftBlocksSize, RowExpression filter) {
        ImmutableSet lambdaAndTryExpressions = ImmutableSet.copyOf(LambdaAndTryExpressionExtractor.extractLambdaAndTryExpressions(filter));
        ImmutableMap.Builder tryMethodMap = ImmutableMap.builder();
        ImmutableMap.Builder lambdaFieldMap = ImmutableMap.builder();
        int counter = 0;
        for (RowExpression expression : lambdaAndTryExpressions) {
            if (expression instanceof CallExpression) {
                CallExpression tryExpression = (CallExpression)expression;
                Verify.verify((!"TRY".equals(tryExpression.getSignature().getName()) ? 1 : 0) != 0);
                Parameter session = Parameter.arg((String)"session", ConnectorSession.class);
                Parameter leftPosition = Parameter.arg((String)"leftPosition", Integer.TYPE);
                Parameter leftBlocks = Parameter.arg((String)"leftBlocks", Block[].class);
                Parameter rightPosition = Parameter.arg((String)"rightPosition", Integer.TYPE);
                Parameter rightBlocks = Parameter.arg((String)"rightBlocks", Block[].class);
                BytecodeExpressionVisitor innerExpressionVisitor = new BytecodeExpressionVisitor(callSiteBinder, cachedInstanceBinder, JoinFilterFunctionCompiler.fieldReferenceCompiler(callSiteBinder, (Variable)leftPosition, (Variable)leftBlocks, (Variable)rightPosition, (Variable)rightBlocks, leftBlocksSize), this.metadata.getFunctionRegistry(), new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build()));
                ImmutableList inputParameters = ImmutableList.builder().add((Object)session).add((Object)leftPosition).add((Object)leftBlocks).add((Object)rightPosition).add((Object)rightBlocks).build();
                MethodDefinition tryMethod = TryCodeGenerator.defineTryMethod(innerExpressionVisitor, containerClassDefinition, "try_" + counter, (List<Parameter>)inputParameters, Primitives.wrap((Class)tryExpression.getType().getJavaType()), tryExpression, callSiteBinder);
                tryMethodMap.put((Object)tryExpression, (Object)tryMethod);
            } else if (expression instanceof LambdaDefinitionExpression) {
                LambdaDefinitionExpression lambdaExpression = (LambdaDefinitionExpression)expression;
                PreGeneratedExpressions preGeneratedExpressions = new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build());
                FieldDefinition methodHandleField = LambdaBytecodeGenerator.preGenerateLambdaExpression(lambdaExpression, "lambda_" + counter, containerClassDefinition, preGeneratedExpressions, callSiteBinder, cachedInstanceBinder, this.metadata.getFunctionRegistry());
                lambdaFieldMap.put((Object)lambdaExpression, (Object)methodHandleField);
            } else {
                throw new VerifyException(String.format("unexpected expression: %s", expression.toString()));
            }
            ++counter;
        }
        return new PreGeneratedExpressions((Map<CallExpression, MethodDefinition>)tryMethodMap.build(), (Map<LambdaDefinitionExpression, FieldDefinition>)lambdaFieldMap.build());
    }

    private static void generateToString(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, String string) {
        classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "toString", ParameterizedType.type(String.class), new Parameter[0]).getBody().append(BytecodeUtils.invoke(callSiteBinder.bind(string, String.class), "toString")).retObject();
    }

    private static RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler(CallSiteBinder callSiteBinder, Variable leftPosition, Variable leftBlocks, Variable rightPosition, Variable rightBlocks, int leftBlocksSize) {
        return new InputReferenceCompiler((scope, field) -> field < leftBlocksSize ? leftBlocks.getElement(field.intValue()) : rightBlocks.getElement(field - leftBlocksSize), (scope, field) -> field < leftBlocksSize ? leftPosition : rightPosition, callSiteBinder);
    }

    private static class IsolatedJoinFilterFunctionFactory
    implements JoinFilterFunctionFactory {
        private final Constructor<? extends InternalJoinFilterFunction> internalJoinFilterFunctionConstructor;
        private final Constructor<? extends JoinFilterFunction> isolatedJoinFilterFunctionConstructor;

        public IsolatedJoinFilterFunctionFactory(Class<? extends InternalJoinFilterFunction> internalJoinFilterFunction) {
            try {
                this.internalJoinFilterFunctionConstructor = internalJoinFilterFunction.getConstructor(ConnectorSession.class);
                Class<StandardJoinFilterFunction> isolatedJoinFilterFunction = IsolatedClass.isolateClass(new DynamicClassLoader(this.getClass().getClassLoader()), JoinFilterFunction.class, StandardJoinFilterFunction.class, new Class[0]);
                this.isolatedJoinFilterFunctionConstructor = isolatedJoinFilterFunction.getConstructor(InternalJoinFilterFunction.class, LongArrayList.class, List.class);
            }
            catch (NoSuchMethodException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        @Override
        public JoinFilterFunction create(ConnectorSession session, LongArrayList addresses, List<List<Block>> channels) {
            try {
                InternalJoinFilterFunction internalJoinFilterFunction = this.internalJoinFilterFunctionConstructor.newInstance(session);
                return this.isolatedJoinFilterFunctionConstructor.newInstance(internalJoinFilterFunction, addresses, channels);
            }
            catch (ReflectiveOperationException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private static final class JoinFilterCacheKey {
        private final RowExpression filter;
        private final int leftBlocksSize;

        public JoinFilterCacheKey(RowExpression filter, int leftBlocksSize) {
            this.filter = Objects.requireNonNull(filter, "filter can not be null");
            this.leftBlocksSize = leftBlocksSize;
        }

        public RowExpression getFilter() {
            return this.filter;
        }

        public int getLeftBlocksSize() {
            return this.leftBlocksSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JoinFilterCacheKey that = (JoinFilterCacheKey)o;
            return this.leftBlocksSize == that.leftBlocksSize && Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return Objects.hash(this.filter, this.leftBlocksSize);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("leftBlocksSize", this.leftBlocksSize).toString();
        }
    }

    @FunctionalInterface
    public static interface JoinFilterFunctionFactory {
        public JoinFilterFunction create(ConnectorSession var1, LongArrayList var2, List<List<Block>> var3);
    }
}

