/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeExpressionVisitor;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.relational.RowExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BytecodeGeneratorContext {
    private final BytecodeExpressionVisitor bytecodeGenerator;
    private final Scope scope;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final FunctionRegistry registry;
    private final Variable wasNull;

    public BytecodeGeneratorContext(BytecodeExpressionVisitor bytecodeGenerator, Scope scope, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, FunctionRegistry registry) {
        Objects.requireNonNull(bytecodeGenerator, "bytecodeGenerator is null");
        Objects.requireNonNull(cachedInstanceBinder, "cachedInstanceBinder is null");
        Objects.requireNonNull(scope, "scope is null");
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(registry, "registry is null");
        this.bytecodeGenerator = bytecodeGenerator;
        this.scope = scope;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.registry = registry;
        this.wasNull = scope.getVariable("wasNull");
    }

    public Scope getScope() {
        return this.scope;
    }

    public CallSiteBinder getCallSiteBinder() {
        return this.callSiteBinder;
    }

    public BytecodeNode generate(RowExpression expression) {
        return expression.accept(this.bytecodeGenerator, this.scope);
    }

    public FunctionRegistry getRegistry() {
        return this.registry;
    }

    public BytecodeNode generateCall(String name, ScalarFunctionImplementation function, List<BytecodeNode> arguments) {
        Binding binding = this.callSiteBinder.bind(function.getMethodHandle());
        Optional<BytecodeNode> instance = Optional.empty();
        if (function.getInstanceFactory().isPresent()) {
            FieldDefinition field = this.cachedInstanceBinder.getCachedInstance(function.getInstanceFactory().get());
            instance = Optional.of(this.scope.getThis().getField(field));
        }
        return BytecodeUtils.generateInvocation(this.scope, name, function, instance, arguments, binding);
    }

    public Variable wasNull() {
        return this.wasNull;
    }
}

