/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.sql.gen.AndCodeGenerator;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CastCodeGenerator;
import com.facebook.presto.sql.gen.CoalesceCodeGenerator;
import com.facebook.presto.sql.gen.DereferenceCodeGenerator;
import com.facebook.presto.sql.gen.FunctionCallCodeGenerator;
import com.facebook.presto.sql.gen.IfCodeGenerator;
import com.facebook.presto.sql.gen.InCodeGenerator;
import com.facebook.presto.sql.gen.IsNullCodeGenerator;
import com.facebook.presto.sql.gen.NullIfCodeGenerator;
import com.facebook.presto.sql.gen.OrCodeGenerator;
import com.facebook.presto.sql.gen.PreGeneratedExpressions;
import com.facebook.presto.sql.gen.RowConstructorCodeGenerator;
import com.facebook.presto.sql.gen.SwitchCodeGenerator;
import com.facebook.presto.sql.gen.TryCodeGenerator;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;

public class BytecodeExpressionVisitor
implements RowExpressionVisitor<Scope, BytecodeNode> {
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler;
    private final FunctionRegistry registry;
    private final PreGeneratedExpressions preGeneratedExpressions;

    public BytecodeExpressionVisitor(CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpressionVisitor<Scope, BytecodeNode> fieldReferenceCompiler, FunctionRegistry registry, PreGeneratedExpressions preGeneratedExpressions) {
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.fieldReferenceCompiler = fieldReferenceCompiler;
        this.registry = registry;
        this.preGeneratedExpressions = preGeneratedExpressions;
    }

    @Override
    public BytecodeNode visitCall(CallExpression call, Scope scope) {
        BytecodeGenerator generator;
        if (call.getSignature().getName().equals(Signatures.CAST)) {
            generator = new CastCodeGenerator();
        } else {
            switch (call.getSignature().getName()) {
                case "IF": {
                    generator = new IfCodeGenerator();
                    break;
                }
                case "NULL_IF": {
                    generator = new NullIfCodeGenerator();
                    break;
                }
                case "SWITCH": {
                    generator = new SwitchCodeGenerator();
                    break;
                }
                case "TRY": {
                    generator = new TryCodeGenerator(this.preGeneratedExpressions.getTryMethodMap());
                    break;
                }
                case "IS_NULL": {
                    generator = new IsNullCodeGenerator();
                    break;
                }
                case "COALESCE": {
                    generator = new CoalesceCodeGenerator();
                    break;
                }
                case "IN": {
                    generator = new InCodeGenerator(this.registry);
                    break;
                }
                case "AND": {
                    generator = new AndCodeGenerator();
                    break;
                }
                case "OR": {
                    generator = new OrCodeGenerator();
                    break;
                }
                case "DEREFERENCE": {
                    generator = new DereferenceCodeGenerator();
                    break;
                }
                case "ROW_CONSTRUCTOR": {
                    generator = new RowConstructorCodeGenerator();
                    break;
                }
                default: {
                    generator = new FunctionCallCodeGenerator();
                }
            }
        }
        BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(this, scope, this.callSiteBinder, this.cachedInstanceBinder, this.registry);
        return generator.generateExpression(call.getSignature(), generatorContext, call.getType(), call.getArguments());
    }

    @Override
    public BytecodeNode visitConstant(ConstantExpression constant, Scope scope) {
        Object value = constant.getValue();
        Class javaType = constant.getType().getJavaType();
        BytecodeBlock block = new BytecodeBlock();
        if (value == null) {
            return block.comment("constant null").append((BytecodeNode)scope.getVariable("wasNull").set(BytecodeExpressions.constantTrue())).pushJavaDefault(javaType);
        }
        block.comment("constant " + constant.getType().getTypeSignature());
        if (javaType == Boolean.TYPE) {
            return block.append((BytecodeNode)Constant.loadBoolean((boolean)((Boolean)value)));
        }
        if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE) {
            return block.append((BytecodeNode)Constant.loadInt((int)((Number)value).intValue()));
        }
        if (javaType == Long.TYPE) {
            return block.append((BytecodeNode)Constant.loadLong((long)((Long)value)));
        }
        if (javaType == Float.TYPE) {
            return block.append((BytecodeNode)Constant.loadFloat((float)((Float)value).floatValue()));
        }
        if (javaType == Double.TYPE) {
            return block.append((BytecodeNode)Constant.loadDouble((double)((Double)value)));
        }
        if (javaType == String.class) {
            return block.append((BytecodeNode)Constant.loadString((String)((String)value)));
        }
        if (javaType == Void.TYPE) {
            return block;
        }
        Binding binding = this.callSiteBinder.bind(value, constant.getType().getJavaType());
        return new BytecodeBlock().setDescription("constant " + constant.getType()).comment(constant.toString()).append((BytecodeNode)BytecodeUtils.loadConstant(binding));
    }

    @Override
    public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        return this.fieldReferenceCompiler.visitInputReference(node, scope);
    }

    @Override
    public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope scope) {
        Preconditions.checkState((boolean)this.preGeneratedExpressions.getLambdaFieldMap().containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
        return BytecodeExpressions.getStatic((FieldDefinition)this.preGeneratedExpressions.getLambdaFieldMap().get(lambda)).invoke("bindTo", MethodHandle.class, new BytecodeExpression[]{scope.getThis().cast(Object.class)}).invoke("bindTo", MethodHandle.class, new BytecodeExpression[]{scope.getVariable("session").cast(Object.class)});
    }

    @Override
    public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope scope) {
        return this.fieldReferenceCompiler.visitVariableReference(reference, scope);
    }
}

