/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

class AggregateExtractor
extends DefaultExpressionTraversalVisitor<Void, Void> {
    private final FunctionRegistry functionRegistry;
    private final ImmutableList.Builder<FunctionCall> aggregates = ImmutableList.builder();

    public AggregateExtractor(FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
    }

    protected Void visitFunctionCall(FunctionCall node, Void context) {
        if ((this.functionRegistry.isAggregationFunction(node.getName()) || node.getFilter().isPresent()) && !node.getWindow().isPresent()) {
            this.aggregates.add((Object)node);
            return null;
        }
        return (Void)super.visitFunctionCall(node, null);
    }

    public List<FunctionCall> getAggregates() {
        return this.aggregates.build();
    }
}

