/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.presto.server.security.KerberosConfig;
import com.facebook.presto.server.security.LdapConfig;
import com.facebook.presto.server.security.LdapFilter;
import com.facebook.presto.server.security.SecurityConfig;
import com.facebook.presto.server.security.SpnegoFilter;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.server.TheServlet;
import java.util.function.Predicate;
import javax.servlet.Filter;

public class ServerSecurityModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder securityBinder) {
        this.bindSecurityConfig(securityConfig -> securityConfig.getAuthenticationType() == SecurityConfig.AuthenticationType.KERBEROS, binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(KerberosConfig.class);
            Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(SpnegoFilter.class).in(Scopes.SINGLETON);
        });
        this.bindSecurityConfig(securityConfig -> securityConfig.getAuthenticationType() == SecurityConfig.AuthenticationType.LDAP, binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(LdapConfig.class);
            Multibinder.newSetBinder((Binder)binder, Filter.class, TheServlet.class).addBinding().to(LdapFilter.class).in(Scopes.SINGLETON);
        });
    }

    private void bindSecurityConfig(Predicate<SecurityConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, predicate, (Module)module));
    }
}

