/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class Backoff {
    private final long minFailureIntervalNanos;
    private final long maxFailureIntervalNanos;
    private final Ticker ticker;
    private final long[] backoffDelayIntervalsNanos;
    private final long createTime;
    private long lastSuccessTime;
    private long firstRequestAfterSuccessTime;
    private long lastFailureTime;
    private long failureCount;

    public Backoff(Duration minFailureInterval, Duration maxFailureInterval) {
        this(minFailureInterval, maxFailureInterval, Ticker.systemTicker(), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(50.0, TimeUnit.MILLISECONDS), new Duration(100.0, TimeUnit.MILLISECONDS), new Duration(200.0, TimeUnit.MILLISECONDS), new Duration(500.0, TimeUnit.MILLISECONDS));
    }

    public Backoff(Duration minFailureInterval, Duration maxFailureInterval, Ticker ticker, Duration ... backoffDelayIntervals) {
        Objects.requireNonNull(minFailureInterval, "minFailureInterval is null");
        Objects.requireNonNull(maxFailureInterval, "maxFailureInterval is null");
        Objects.requireNonNull(ticker, "ticker is null");
        Objects.requireNonNull(backoffDelayIntervals, "backoffDelayIntervals is null");
        Preconditions.checkArgument((backoffDelayIntervals.length > 0 ? 1 : 0) != 0, (Object)"backoffDelayIntervals must contain at least one entry");
        Preconditions.checkArgument((maxFailureInterval.compareTo(minFailureInterval) >= 0 ? 1 : 0) != 0, (Object)"maxFailureInterval is less than minFailureInterval");
        this.minFailureIntervalNanos = minFailureInterval.roundTo(TimeUnit.NANOSECONDS);
        this.maxFailureIntervalNanos = maxFailureInterval.roundTo(TimeUnit.NANOSECONDS);
        this.ticker = ticker;
        this.backoffDelayIntervalsNanos = new long[backoffDelayIntervals.length];
        for (int i = 0; i < backoffDelayIntervals.length; ++i) {
            this.backoffDelayIntervalsNanos[i] = backoffDelayIntervals[i].roundTo(TimeUnit.NANOSECONDS);
        }
        this.lastSuccessTime = this.ticker.read();
        this.firstRequestAfterSuccessTime = Long.MIN_VALUE;
        this.createTime = this.ticker.read();
    }

    public synchronized long getFailureCount() {
        return this.failureCount;
    }

    public synchronized Duration getTimeSinceLastSuccess() {
        long lastSuccessfulRequest = this.lastSuccessTime;
        long value = this.ticker.read() - lastSuccessfulRequest;
        return new Duration((double)value, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit();
    }

    public synchronized void startRequest() {
        if (this.firstRequestAfterSuccessTime < this.lastSuccessTime) {
            this.firstRequestAfterSuccessTime = this.ticker.read();
        }
    }

    public synchronized void success() {
        this.lastSuccessTime = this.ticker.read();
        this.failureCount = 0L;
        this.lastFailureTime = 0L;
    }

    public synchronized boolean failure() {
        long now;
        long lastSuccessfulRequest = this.lastSuccessTime;
        this.lastFailureTime = now = this.ticker.read();
        ++this.failureCount;
        long failureInterval = lastSuccessfulRequest - this.createTime > this.maxFailureIntervalNanos ? this.maxFailureIntervalNanos : Math.max(lastSuccessfulRequest - this.createTime, this.minFailureIntervalNanos);
        long failureDuration = this.firstRequestAfterSuccessTime < this.lastSuccessTime ? now - lastSuccessfulRequest : now - this.firstRequestAfterSuccessTime;
        return failureDuration >= failureInterval;
    }

    public synchronized long getBackoffDelayNanos() {
        int failureCount = (int)Math.min((long)this.backoffDelayIntervalsNanos.length, this.failureCount);
        if (failureCount == 0) {
            return 0L;
        }
        long currentDelay = this.backoffDelayIntervalsNanos[failureCount - 1];
        long nanosSinceLastFailure = this.ticker.read() - this.lastFailureTime;
        return Math.max(0L, currentDelay - nanosSinceLastFailure);
    }
}

