/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

final class HttpRequestSessionFactory
implements SessionSupplier {
    private final String catalog;
    private final String schema;
    private final Identity identity;
    private final String source;
    private final String userAgent;
    private final String remoteUserAddress;
    private final String timeZoneId;
    private final String language;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Map<String, String> preparedStatements;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String clientInfo;

    public HttpRequestSessionFactory(HttpServletRequest servletRequest) throws WebApplicationException {
        this.catalog = HttpRequestSessionFactory.trimEmptyToNull(servletRequest.getHeader("X-Presto-Catalog"));
        this.schema = HttpRequestSessionFactory.trimEmptyToNull(servletRequest.getHeader("X-Presto-Schema"));
        HttpRequestSessionFactory.assertRequest(this.catalog != null || this.schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = HttpRequestSessionFactory.trimEmptyToNull(servletRequest.getHeader("X-Presto-User"));
        HttpRequestSessionFactory.assertRequest(user != null, "User must be set", new Object[0]);
        this.identity = new Identity(user, Optional.ofNullable(servletRequest.getUserPrincipal()));
        this.source = servletRequest.getHeader("X-Presto-Source");
        this.userAgent = servletRequest.getHeader("User-Agent");
        this.remoteUserAddress = servletRequest.getRemoteAddr();
        this.timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        this.language = servletRequest.getHeader("X-Presto-Language");
        this.clientInfo = servletRequest.getHeader("X-Presto-Client-Info");
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashMap<String, Map> catalogSessionProperties = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry2 : HttpRequestSessionFactory.parseSessionHeaders(servletRequest).entrySet()) {
            String fullPropertyName = entry2.getKey();
            String propertyValue = entry2.getValue();
            List nameParts = Splitter.on((char)'.').splitToList((CharSequence)fullPropertyName);
            if (nameParts.size() == 1) {
                String propertyName = (String)nameParts.get(0);
                HttpRequestSessionFactory.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                systemProperties.put((Object)propertyName, (Object)propertyValue);
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.get(0);
                String propertyName = (String)nameParts.get(1);
                HttpRequestSessionFactory.assertRequest(!catalogName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                HttpRequestSessionFactory.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
                continue;
            }
            throw HttpRequestSessionFactory.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        this.systemProperties = systemProperties.build();
        this.catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableCollectors.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.preparedStatements = HttpRequestSessionFactory.parsePreparedStatementsHeaders(servletRequest);
        String transactionIdHeader = servletRequest.getHeader("X-Presto-Transaction-Id");
        this.clientTransactionSupport = transactionIdHeader != null;
        this.transactionId = HttpRequestSessionFactory.parseTransactionId(transactionIdHeader);
    }

    @Override
    public Identity getIdentity() {
        return this.identity;
    }

    @Override
    public Session createSession(QueryId queryId, TransactionManager transactionManager, AccessControl accessControl, SessionPropertyManager sessionPropertyManager) {
        accessControl.checkCanSetUser(this.identity.getPrincipal().orElse(null), this.identity.getUser());
        Session.SessionBuilder sessionBuilder = Session.builder(sessionPropertyManager).setQueryId(queryId).setIdentity(this.identity).setSource(this.source).setCatalog(this.catalog).setSchema(this.schema).setRemoteUserAddress(this.remoteUserAddress).setUserAgent(this.userAgent).setClientInfo(this.clientInfo);
        if (this.timeZoneId != null) {
            sessionBuilder.setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)this.timeZoneId));
        }
        if (this.language != null) {
            sessionBuilder.setLocale(Locale.forLanguageTag(this.language));
        }
        for (Map.Entry<String, String> entry : this.systemProperties.entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.catalogSessionProperties.entrySet()) {
            String catalog = entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                sessionBuilder.setCatalogSessionProperty(catalog, (String)entry2.getKey(), (String)entry2.getValue());
            }
        }
        for (Map.Entry<String, Object> entry : this.preparedStatements.entrySet()) {
            sessionBuilder.addPreparedStatement(entry.getKey(), (String)entry.getValue());
        }
        if (this.clientTransactionSupport) {
            sessionBuilder.setClientTransactionSupport();
        }
        Session session = sessionBuilder.build();
        if (this.transactionId.isPresent()) {
            session = session.beginTransactionId(this.transactionId.get(), transactionManager, accessControl);
        }
        return session;
    }

    private static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(HttpServletRequest servletRequest) {
        HashMap<String, String> sessionProperties = new HashMap<String, String>();
        for (String header : HttpRequestSessionFactory.splitSessionHeader(servletRequest.getHeaders("X-Presto-Session"))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionFactory.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session");
            sessionProperties.put((String)nameValue.get(0), (String)nameValue.get(1));
        }
        return sessionProperties;
    }

    private static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw HttpRequestSessionFactory.badRequest(String.format(format, args));
        }
    }

    private static Map<String, String> parsePreparedStatementsHeaders(HttpServletRequest servletRequest) {
        HashMap<String, String> preparedStatements = new HashMap<String, String>();
        for (String header : HttpRequestSessionFactory.splitSessionHeader(servletRequest.getHeaders("X-Presto-Prepared-Statement"))) {
            String sqlString;
            String statementName;
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionFactory.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Prepared-Statement");
            try {
                statementName = HttpRequestSessionFactory.urlDecode((String)nameValue.get(0));
                sqlString = HttpRequestSessionFactory.urlDecode((String)nameValue.get(1));
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionFactory.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            SqlParser sqlParser = new SqlParser();
            try {
                sqlParser.createStatement(sqlString);
            }
            catch (ParsingException e) {
                throw HttpRequestSessionFactory.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            preparedStatements.put(statementName, sqlString);
        }
        return preparedStatements;
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = HttpRequestSessionFactory.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw HttpRequestSessionFactory.badRequest(e.getMessage());
        }
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

