/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.SqlWindowFunction;
import com.facebook.presto.spi.function.WindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;

public final class WindowAnnotationsParser {
    private WindowAnnotationsParser() {
    }

    public static List<SqlWindowFunction> parseFunctionDefinition(Class<? extends WindowFunction> clazz) {
        WindowFunctionSignature[] signatures = (WindowFunctionSignature[])clazz.getAnnotationsByType(WindowFunctionSignature.class);
        Preconditions.checkArgument((signatures.length > 0 ? 1 : 0) != 0, (String)"Class is not annotated with @WindowFunctionSignature: %s", (Object)clazz.getName());
        return (List)Stream.of(signatures).map(signature -> WindowAnnotationsParser.parse(clazz, signature)).collect(ImmutableCollectors.toImmutableList());
    }

    private static SqlWindowFunction parse(Class<? extends WindowFunction> clazz, WindowFunctionSignature window) {
        ImmutableList typeVariables = ImmutableList.of();
        if (!window.typeVariable().isEmpty()) {
            typeVariables = ImmutableList.of((Object)Signature.typeVariable(window.typeVariable()));
        }
        List argumentTypes = (List)Stream.of(window.argumentTypes()).map(TypeSignature::parseTypeSignature).collect(ImmutableCollectors.toImmutableList());
        Signature signature = new Signature(window.name(), FunctionKind.WINDOW, (List<TypeVariableConstraint>)typeVariables, (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)window.returnType()), argumentTypes, false);
        return new SqlWindowFunction(new ReflectionWindowFunctionSupplier<WindowFunction>(signature, clazz));
    }
}

