/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.window.AbstractWindowFunctionSupplier;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.WindowFunction;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;

public class ReflectionWindowFunctionSupplier<T extends WindowFunction>
extends AbstractWindowFunctionSupplier {
    private final Constructor<T> constructor;

    public ReflectionWindowFunctionSupplier(String name, Type returnType, List<? extends Type> argumentTypes, Class<T> type) {
        this(new Signature(name, FunctionKind.WINDOW, returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature)), type);
    }

    public ReflectionWindowFunctionSupplier(Signature signature, Class<T> type) {
        super(signature, ReflectionWindowFunctionSupplier.getDescription(Objects.requireNonNull(type, "type is null")));
        try {
            this.constructor = signature.getArgumentTypes().isEmpty() ? type.getConstructor(new Class[0]) : type.getConstructor(List.class);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected T newWindowFunction(List<Integer> inputs) {
        try {
            if (this.getSignature().getArgumentTypes().isEmpty()) {
                return (T)((WindowFunction)this.constructor.newInstance(new Object[0]));
            }
            return (T)((WindowFunction)this.constructor.newInstance(inputs));
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }
}

