/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionDependency;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.Constraint;
import com.facebook.presto.type.LiteralParameter;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ScalarImplementation {
    private final Signature signature;
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final List<Boolean> nullFlags;
    private final MethodHandle methodHandle;
    private final List<ImplementationDependency> dependencies;
    private final Optional<MethodHandle> constructor;
    private final List<ImplementationDependency> constructorDependencies;
    private final List<Class<?>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;

    public ScalarImplementation(Signature signature, boolean nullable, List<Boolean> nullableArguments, List<Boolean> nullFlags, MethodHandle methodHandle, List<ImplementationDependency> dependencies, Optional<MethodHandle> constructor, List<ImplementationDependency> constructorDependencies, List<Class<?>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.nullable = nullable;
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        this.nullFlags = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullFlags, "nullFlags is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
    }

    public Optional<MethodHandleAndConstructor> specialize(Signature boundSignature, BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue().isAssignableFrom(boundVariables.getTypeVariable(entry.getKey()).getJavaType())) continue;
            return Optional.empty();
        }
        Class<?> returnContainerType = ScalarImplementation.getNullAwareReturnType(typeManager.getType(boundSignature.getReturnType()).getJavaType(), this.nullable);
        if (!returnContainerType.equals(this.methodHandle.type().returnType())) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            Class argumentType = typeManager.getType(boundSignature.getArgumentTypes().get(i)).getJavaType();
            boolean nullableParameter = ScalarImplementation.isParameterNullable(argumentType, this.nullableArguments.get(i), this.nullFlags.get(i));
            Class<?> argumentContainerType = ScalarImplementation.getNullAwareContainerType(argumentType, nullableParameter);
            if (this.argumentNativeContainerTypes.get(i).isAssignableFrom(argumentContainerType)) continue;
            return Optional.empty();
        }
        MethodHandle methodHandle = this.methodHandle;
        for (ImplementationDependency dependency : this.dependencies) {
            methodHandle = methodHandle.bindTo(dependency.resolve(boundVariables, typeManager, functionRegistry));
        }
        MethodHandle constructor = null;
        if (this.constructor.isPresent()) {
            constructor = this.constructor.get();
            for (ImplementationDependency dependency : this.constructorDependencies) {
                constructor = constructor.bindTo(dependency.resolve(boundVariables, typeManager, functionRegistry));
            }
        }
        return Optional.of(new MethodHandleAndConstructor(methodHandle, Optional.ofNullable(constructor)));
    }

    private static Class<?> getNullAwareReturnType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (clazz == Void.TYPE) {
            return Primitives.wrap(clazz);
        }
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    private static boolean isParameterNullable(Class<?> type, boolean nullableArgument, boolean nullFlag) {
        if (!nullableArgument) {
            return false;
        }
        if (type == Void.TYPE) {
            return true;
        }
        if (nullFlag) {
            return !type.isPrimitive();
        }
        return true;
    }

    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public List<Boolean> getNullFlags() {
        return this.nullFlags;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public List<ImplementationDependency> getDependencies() {
        return this.dependencies;
    }

    public static final class Parser {
        private static final Set<OperatorType> COMPARABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.EQUAL, (Object)OperatorType.NOT_EQUAL, (Object)OperatorType.HASH_CODE);
        private static final Set<OperatorType> ORDERABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL, (Object)OperatorType.BETWEEN);
        private final String functionName;
        private final boolean nullable;
        private final List<Boolean> nullableArguments = new ArrayList<Boolean>();
        private final List<Boolean> nullFlags = new ArrayList<Boolean>();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Class<?>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final LinkedHashSet<TypeParameter> typeParameters = new LinkedHashSet();
        private final Set<String> literalParameters = new HashSet<String>();
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Optional<MethodHandle> constructorMethodHandle;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints = new ArrayList<LongVariableConstraint>();

        private Parser(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            SqlType returnType;
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.nullable = method.getAnnotation(SqlNullable.class) != null;
            Preconditions.checkArgument((this.nullable || !Parser.containsLegacyNullable(method.getAnnotations()) ? 1 : 0) != 0, (String)"Method [%s] is annotated with @Nullable but not @SqlNullable", (Object)method);
            Stream.of(method.getAnnotationsByType(TypeParameter.class)).forEach(this.typeParameters::add);
            LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
            if (literalParametersAnnotation != null) {
                this.literalParameters.addAll(Arrays.asList(literalParametersAnnotation.value()));
            }
            Preconditions.checkArgument(((returnType = method.getAnnotation(SqlType.class)) != null ? 1 : 0) != 0, (Object)String.format("Method [%s] is missing @SqlType annotation", method));
            this.returnType = TypeSignature.parseTypeSignature((String)returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)this.nullable, (String)"Method [%s] has wrapper return type %s but is missing @SqlNullable", (Object)method, (Object)actualReturnType.getSimpleName());
            } else if (actualReturnType.isPrimitive()) {
                Preconditions.checkArgument((!this.nullable ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlNullable has primitive return type %s", (Object)method, (Object)actualReturnType.getSimpleName());
            }
            Stream.of(method.getAnnotationsByType(Constraint.class)).map(annotation -> new LongVariableConstraint(annotation.variable(), annotation.expression())).forEach(this.longVariableConstraints::add);
            this.specializedTypeParameters = this.getDeclaredSpecializedTypeParameters(method);
            this.parseArguments(method);
            this.constructorMethodHandle = this.getConstructor(method, constructors);
            this.methodHandle = this.getMethodHandle(method);
        }

        private void parseArguments(Method method) {
            ImmutableSet typeParameterNames = this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableCollectors.toImmutableSet());
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Annotation[] annotations = method.getParameterAnnotations()[i];
                Class<?> parameterType = method.getParameterTypes()[i];
                if (parameterType == ConnectorSession.class) continue;
                if (Parser.containsMetaParameter(annotations)) {
                    Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", (Object)method);
                    Preconditions.checkArgument((boolean)this.argumentTypes.isEmpty(), (String)"Meta parameter must come before parameters [%s]", (Object)method);
                    Annotation annotation = annotations[0];
                    if (annotation instanceof TypeParameter) {
                        Preconditions.checkArgument((boolean)this.typeParameters.contains(annotation), (String)"Injected type parameters must be declared with @TypeParameter annotation on the method [%s]", (Object)method);
                    }
                    if (annotation instanceof LiteralParameter) {
                        Preconditions.checkArgument((boolean)this.literalParameters.contains(((LiteralParameter)annotation).value()), (String)"Parameter injected by @LiteralParameter must be declared with @LiteralParameters on the method [%s]", (Object)method);
                    }
                    this.dependencies.add(this.parseDependency(annotation));
                    continue;
                }
                Preconditions.checkArgument((!Stream.of(annotations).anyMatch(IsNull.class::isInstance) ? 1 : 0) != 0, (String)"Method [%s] has @IsNull parameter that does not follow a @SqlType parameter", (Object)method);
                SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
                boolean nullableArgument = Stream.of(annotations).anyMatch(SqlNullable.class::isInstance);
                Preconditions.checkArgument((nullableArgument || !Parser.containsLegacyNullable(annotations) ? 1 : 0) != 0, (String)"Method [%s] has parameter annotated with @Nullable but not @SqlNullable", (Object)method);
                boolean hasNullFlag = false;
                if (method.getParameterCount() > i + 1) {
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                    if (Stream.of(parameterAnnotations).anyMatch(IsNull.class::isInstance)) {
                        Class<?> isNullType = method.getParameterTypes()[i + 1];
                        Preconditions.checkArgument((boolean)Stream.of(parameterAnnotations).filter(Parser::isPrestoAnnotation).allMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that has other annotations", (Object)method);
                        Preconditions.checkArgument((isNullType == Boolean.TYPE ? 1 : 0) != 0, (String)"Method [%s] has non-boolean parameter with @IsNull", (Object)method);
                        Preconditions.checkArgument((parameterType == Void.class || !Primitives.isWrapperType(parameterType) ? 1 : 0) != 0, (String)"Method [%s] uses @IsNull following a parameter with boxed primitive type: %s", (Object)method, (Object)parameterType.getSimpleName());
                        nullableArgument = true;
                        hasNullFlag = true;
                    }
                }
                if (Primitives.isWrapperType(parameterType)) {
                    Preconditions.checkArgument((boolean)nullableArgument, (String)"Method [%s] has parameter with wrapper type %s that is missing @SqlNullable", (Object)method, (Object)parameterType.getSimpleName());
                } else if (parameterType.isPrimitive() && !hasNullFlag) {
                    Preconditions.checkArgument((!nullableArgument ? 1 : 0) != 0, (String)"Method [%s] has parameter with primitive type %s annotated with @SqlNullable", (Object)method, (Object)parameterType.getSimpleName());
                }
                if (typeParameterNames.contains((Object)type.value()) && (parameterType != Object.class || !nullableArgument)) {
                    Class<?> specialization = this.specializedTypeParameters.get(type.value());
                    Class nativeParameterType = Primitives.unwrap(parameterType);
                    Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"Method [%s] type %s has conflicting specializations %s and %s", (Object)method, (Object)type.value(), specialization, (Object)nativeParameterType);
                    this.specializedTypeParameters.put(type.value(), nativeParameterType);
                }
                this.argumentNativeContainerTypes.add(parameterType);
                this.argumentTypes.add(TypeSignature.parseTypeSignature((String)type.value(), this.literalParameters));
                if (hasNullFlag) {
                    ++i;
                }
                this.nullableArguments.add(nullableArgument);
                this.nullFlags.add(hasNullFlag);
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Constructor<?> constructor = constructors.get(this.typeParameters);
            Preconditions.checkArgument((constructor != null ? 1 : 0) != 0, (String)"Method [%s] is an instance method and requires a public constructor to be declared with %s type parameters", (Object)method, this.typeParameters);
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)Parser.containsMetaParameter(annotations), (String)"Constructors may only have meta parameters [%s]", constructor);
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", constructor);
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    Preconditions.checkArgument((boolean)this.typeParameters.contains(annotation), (String)"Injected type parameters must be declared with @TypeParameter annotation on the constructor [%s]", constructor);
                }
                this.constructorDependencies.add(this.parseDependency(annotation));
            }
            try {
                return Optional.of(MethodHandles.lookup().unreflectConstructor(constructor));
            }
            catch (IllegalAccessException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, (Throwable)e);
            }
        }

        private Map<String, Class<?>> getDeclaredSpecializedTypeParameters(Method method) {
            HashMap specializedTypeParameters = new HashMap();
            TypeParameterSpecialization[] typeParameterSpecializations = (TypeParameterSpecialization[])method.getAnnotationsByType(TypeParameterSpecialization.class);
            ImmutableSet typeParameterNames = this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableCollectors.toImmutableSet());
            for (TypeParameterSpecialization specialization : typeParameterSpecializations) {
                Preconditions.checkArgument((boolean)typeParameterNames.contains((Object)specialization.name()), (String)"%s does not match any declared type parameters (%s) [%s]", (Object)specialization.name(), this.typeParameters, (Object)method);
                Class existingSpecialization = (Class)specializedTypeParameters.get(specialization.name());
                Preconditions.checkArgument((existingSpecialization == null || existingSpecialization.equals(specialization.nativeContainerType()) ? 1 : 0) != 0, (String)"%s has conflicting specializations %s and %s [%s]", (Object)specialization.name(), (Object)existingSpecialization, (Object)specialization.nativeContainerType(), (Object)method);
                specializedTypeParameters.put(specialization.name(), specialization.nativeContainerType());
            }
            return specializedTypeParameters;
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle;
            try {
                methodHandle = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, (Throwable)e);
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        private static List<TypeVariableConstraint> createTypeVariableConstraints(Iterable<TypeParameter> typeParameters, List<ImplementationDependency> dependencies) {
            HashSet<String> orderableRequired = new HashSet<String>();
            HashSet<String> comparableRequired = new HashSet<String>();
            for (ImplementationDependency dependency : dependencies) {
                OperatorType operator;
                if (!(dependency instanceof OperatorImplementationDependency) || (operator = ((OperatorImplementationDependency)dependency).getOperator()) == OperatorType.CAST) continue;
                Set argumentTypes = (Set)((OperatorImplementationDependency)dependency).getSignature().getArgumentTypes().stream().map(TypeSignature::getBase).collect(ImmutableCollectors.toImmutableSet());
                Preconditions.checkArgument((argumentTypes.size() == 1 ? 1 : 0) != 0, (Object)"Operator dependency must only have arguments of a single type");
                String argumentType = (String)Iterables.getOnlyElement((Iterable)argumentTypes);
                if (COMPARABLE_TYPE_OPERATORS.contains(operator)) {
                    comparableRequired.add(argumentType);
                }
                if (!ORDERABLE_TYPE_OPERATORS.contains(operator)) continue;
                orderableRequired.add(argumentType);
            }
            ImmutableList.Builder typeVariableConstraints = ImmutableList.builder();
            for (TypeParameter typeParameter : typeParameters) {
                String name = typeParameter.value();
                if (orderableRequired.contains(name)) {
                    typeVariableConstraints.add((Object)Signature.orderableTypeParameter(name));
                    continue;
                }
                if (comparableRequired.contains(name)) {
                    typeVariableConstraints.add((Object)Signature.comparableTypeParameter(name));
                    continue;
                }
                typeVariableConstraints.add((Object)Signature.typeVariable(name));
            }
            return typeVariableConstraints.build();
        }

        private ImplementationDependency parseDependency(Annotation annotation) {
            if (annotation instanceof TypeParameter) {
                return new TypeImplementationDependency(((TypeParameter)annotation).value());
            }
            if (annotation instanceof LiteralParameter) {
                return new LiteralImplementationDependency(((LiteralParameter)annotation).value());
            }
            if (annotation instanceof FunctionDependency) {
                FunctionDependency function = (FunctionDependency)annotation;
                return new FunctionImplementationDependency(function.name(), TypeSignature.parseTypeSignature((String)function.returnType(), this.literalParameters), (List)Arrays.stream(function.argumentTypes()).map(signature -> TypeSignature.parseTypeSignature((String)signature, this.literalParameters)).collect(ImmutableCollectors.toImmutableList()));
            }
            if (annotation instanceof OperatorDependency) {
                OperatorDependency operator = (OperatorDependency)annotation;
                return new OperatorImplementationDependency(operator.operator(), TypeSignature.parseTypeSignature((String)operator.returnType(), this.literalParameters), (List)Arrays.stream(operator.argumentTypes()).map(signature -> TypeSignature.parseTypeSignature((String)signature, this.literalParameters)).collect(ImmutableCollectors.toImmutableList()));
            }
            throw new IllegalArgumentException("Unsupported annotation " + annotation.getClass().getSimpleName());
        }

        private static boolean containsMetaParameter(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (!Parser.isMetaParameter(annotation)) continue;
                return true;
            }
            return false;
        }

        private static boolean isMetaParameter(Annotation annotation) {
            return annotation instanceof TypeParameter || annotation instanceof LiteralParameter || annotation instanceof FunctionDependency || annotation instanceof OperatorDependency;
        }

        public ScalarImplementation get() {
            Signature signature = new Signature(this.functionName, FunctionKind.SCALAR, Parser.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
            return new ScalarImplementation(signature, this.nullable, this.nullableArguments, this.nullFlags, this.methodHandle, this.dependencies, this.constructorMethodHandle, this.constructorDependencies, this.argumentNativeContainerTypes, this.specializedTypeParameters);
        }

        public static ScalarImplementation parseImplementation(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            return new Parser(functionName, method, constructors).get();
        }

        private static boolean containsLegacyNullable(Annotation[] annotations) {
            return Arrays.stream(annotations).map(Annotation::annotationType).map(Class::getName).anyMatch(name -> name.equals(Nullable.class.getName()));
        }

        private static boolean isPrestoAnnotation(Annotation annotation) {
            return Parser.isMetaParameter(annotation) || annotation instanceof SqlType || annotation instanceof SqlNullable || annotation instanceof IsNull;
        }
    }

    private static final class LiteralImplementationDependency
    implements ImplementationDependency {
        private final String literalName;

        private LiteralImplementationDependency(String literalName) {
            this.literalName = Objects.requireNonNull(literalName, "literalName is null");
        }

        @Override
        public Long resolve(BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return boundVariables.getLongVariable(this.literalName);
        }
    }

    private static final class TypeImplementationDependency
    implements ImplementationDependency {
        private final TypeSignature signature;

        private TypeImplementationDependency(String signature) {
            this.signature = TypeSignature.parseTypeSignature((String)Objects.requireNonNull(signature, "signature is null"));
        }

        public Type resolve(BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return typeManager.getType(SignatureBinder.applyBoundVariables(this.signature, boundVariables));
        }
    }

    private static abstract class ScalarImplementationDependency
    implements ImplementationDependency {
        private final Signature signature;

        private ScalarImplementationDependency(Signature signature) {
            this.signature = Objects.requireNonNull(signature, "signature is null");
        }

        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public MethodHandle resolve(BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
            Signature signature = SignatureBinder.applyBoundVariables(this.signature, boundVariables, this.signature.getArgumentTypes().size());
            return functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
        }
    }

    private static final class OperatorImplementationDependency
    extends ScalarImplementationDependency {
        private final OperatorType operator;

        private OperatorImplementationDependency(OperatorType operator, TypeSignature returnType, List<TypeSignature> argumentTypes) {
            super(Signature.internalOperator(operator, returnType, argumentTypes));
            this.operator = Objects.requireNonNull(operator, "operator is null");
        }

        public OperatorType getOperator() {
            return this.operator;
        }
    }

    private static final class FunctionImplementationDependency
    extends ScalarImplementationDependency {
        private FunctionImplementationDependency(String name, TypeSignature returnType, List<TypeSignature> argumentTypes) {
            super(Signature.internalScalarFunction(name, returnType, argumentTypes));
        }
    }

    private static interface ImplementationDependency {
        public Object resolve(BoundVariables var1, TypeManager var2, FunctionRegistry var3);
    }

    public static final class MethodHandleAndConstructor {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;

        public MethodHandleAndConstructor(MethodHandle methodHandle, Optional<MethodHandle> constructor) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }
    }
}

