/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MapTransformKeyFunction
extends SqlScalarFunction {
    public static final MapTransformKeyFunction MAP_TRANSFORM_KEY_FUNCTION = new MapTransformKeyFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapTransformKeyFunction.class, "transform", Type.class, Type.class, Type.class, ConnectorSession.class, Block.class, MethodHandle.class);

    private MapTransformKeyFunction() {
        super(new Signature("transform_keys", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K1"), (Object)Signature.typeVariable("K2"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(K2,V)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K1,V)"), (Object)TypeSignature.parseTypeSignature((String)"function(K1,V,K2)")), false));
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public String getDescription() {
        return "apply lambda to each entry of the map and transform the key";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K1");
        Type transformedKeyType = boundVariables.getTypeVariable("K2");
        Type valueType = boundVariables.getTypeVariable("V");
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE.bindTo(keyType).bindTo(transformedKeyType).bindTo(valueType), this.isDeterministic());
    }

    public static Block transform(Type keyType, Type transformedKeyType, Type valueType, ConnectorSession session, Block block, MethodHandle function) {
        int positionCount = block.getPositionCount();
        InterleavedBlockBuilder resultBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)transformedKeyType, (Object)valueType), new BlockBuilderStatus(), positionCount);
        TypedSet typedSet = new TypedSet(transformedKeyType, positionCount / 2);
        for (int position = 0; position < positionCount; position += 2) {
            Object transformedKey;
            Object key = TypeUtils.readNativeValue((Type)keyType, (Block)block, (int)position);
            Object value = TypeUtils.readNativeValue((Type)valueType, (Block)block, (int)(position + 1));
            try {
                transformedKey = function.invoke(key, value);
            }
            catch (Throwable throwable) {
                throw Throwables.propagate((Throwable)throwable);
            }
            if (transformedKey == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "map key cannot be null");
            }
            TypeUtils.writeNativeValue((Type)transformedKeyType, (BlockBuilder)resultBuilder, (Object)transformedKey);
            valueType.appendTo(block, position + 1, (BlockBuilder)resultBuilder);
            if (typedSet.contains((Block)resultBuilder, position)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Duplicate keys (%s) are not allowed", transformedKeyType.getObjectValue(session, (Block)resultBuilder, position)));
            }
            typedSet.add((Block)resultBuilder, position);
        }
        return resultBuilder.build();
    }
}

