/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;

@ScalarFunction(value="element_at")
@Description(value="Get element of array at given index")
public final class ArrayElementAtFunction {
    private ArrayElementAtFunction() {
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Void voidElementAt(@SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        return null;
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Long longElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Boolean booleanElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Double doubleElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Slice sliceElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    @TypeParameter(value="E")
    @SqlNullable
    @SqlType(value="E")
    public static Block blockElementAt(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block array, @SqlType(value="bigint") long index) {
        int position = ArrayElementAtFunction.checkedIndexToBlockPosition(array, index);
        if (position == -1) {
            return null;
        }
        if (array.isNull(position)) {
            return null;
        }
        return (Block)elementType.getObject(array, position);
    }

    private static int checkedIndexToBlockPosition(Block block, long index) {
        int arrayLength = block.getPositionCount();
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (Math.abs(index) > (long)arrayLength) {
            return -1;
        }
        if (index > 0L) {
            return Math.toIntExact(index - 1L);
        }
        return Math.toIntExact((long)arrayLength + index);
    }
}

