/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;

@ScalarFunction(value="concat")
@Description(value="Concatenates given arrays")
public final class ArrayConcatFunction {
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayConcatFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block concat(@TypeParameter(value="E") Type elementType, @SqlType(value="array(E)") Block leftBlock, @SqlType(value="array(E)") Block rightBlock) {
        int i;
        if (leftBlock.getPositionCount() == 0) {
            return rightBlock;
        }
        if (rightBlock.getPositionCount() == 0) {
            return leftBlock;
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder blockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (i = 0; i < leftBlock.getPositionCount(); ++i) {
            elementType.appendTo(leftBlock, i, blockBuilder);
        }
        for (i = 0; i < rightBlock.getPositionCount(); ++i) {
            elementType.appendTo(rightBlock, i, blockBuilder);
        }
        int total = leftBlock.getPositionCount() + rightBlock.getPositionCount();
        this.pageBuilder.declarePositions(total);
        return blockBuilder.getRegion(blockBuilder.getPositionCount() - total, total);
    }
}

