/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.TypedHistogram;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.HistogramState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class HistogramStateFactory
implements AccumulatorStateFactory<HistogramState> {
    public HistogramState createSingleState() {
        return new SingleState();
    }

    public Class<? extends HistogramState> getSingleStateClass() {
        return SingleState.class;
    }

    public HistogramState createGroupedState() {
        return new GroupedState();
    }

    public Class<? extends HistogramState> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements HistogramState {
        private TypedHistogram typedHistogram;

        @Override
        public TypedHistogram get() {
            return this.typedHistogram;
        }

        @Override
        public void set(TypedHistogram value) {
            this.typedHistogram = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }

        public long getEstimatedSize() {
            if (this.typedHistogram == null) {
                return 0L;
            }
            return this.typedHistogram.getEstimatedSize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements HistogramState {
        private final ObjectBigArray<TypedHistogram> typedHistogram = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.typedHistogram.ensureCapacity(size);
        }

        @Override
        public TypedHistogram get() {
            return (TypedHistogram)this.typedHistogram.get(this.getGroupId());
        }

        @Override
        public void set(TypedHistogram value) {
            Objects.requireNonNull(value, "value is null");
            TypedHistogram previous = this.get();
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.typedHistogram.set(this.getGroupId(), (Object)value);
            this.size += value.getEstimatedSize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        public long getEstimatedSize() {
            return this.size + this.typedHistogram.sizeOf();
        }
    }
}

