/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.BigIntegerAndLongStateFactory;
import com.facebook.presto.operator.aggregation.state.BigIntegerState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.math.BigInteger;
import java.util.Objects;

public class BigIntegerStateFactory
implements AccumulatorStateFactory<BigIntegerState> {
    public BigIntegerState createSingleState() {
        return new SingleBigIntegerState();
    }

    public Class<? extends BigIntegerState> getSingleStateClass() {
        return SingleBigIntegerState.class;
    }

    public BigIntegerState createGroupedState() {
        return new GroupedBigIntegerState();
    }

    public Class<? extends BigIntegerState> getGroupedStateClass() {
        return GroupedBigIntegerState.class;
    }

    public static class SingleBigIntegerState
    implements BigIntegerState {
        private BigInteger bigInteger;

        @Override
        public BigInteger getBigInteger() {
            return this.bigInteger;
        }

        @Override
        public void setBigInteger(BigInteger bigInteger) {
            this.bigInteger = bigInteger;
        }

        public long getEstimatedSize() {
            if (this.bigInteger == null) {
                return 0L;
            }
            return BigIntegerAndLongStateFactory.BIG_INTEGER_APPROX_SIZE;
        }
    }

    public static class GroupedBigIntegerState
    extends AbstractGroupedAccumulatorState
    implements BigIntegerState {
        private final ObjectBigArray<BigInteger> bigIntegers = new ObjectBigArray();
        private long estimatedSizeOfBigIntegerObjects;

        public void ensureCapacity(long size) {
            this.bigIntegers.ensureCapacity(size);
        }

        @Override
        public BigInteger getBigInteger() {
            return (BigInteger)this.bigIntegers.get(this.getGroupId());
        }

        @Override
        public void setBigInteger(BigInteger value) {
            Objects.requireNonNull(value, "value is null");
            if (this.getBigInteger() == null) {
                this.estimatedSizeOfBigIntegerObjects += BigIntegerAndLongStateFactory.BIG_INTEGER_APPROX_SIZE;
            }
            this.bigIntegers.set(this.getGroupId(), (Object)value);
        }

        public long getEstimatedSize() {
            return this.bigIntegers.sizeOf() + this.estimatedSizeOfBigIntegerObjects + 8L;
        }
    }
}

