/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.BigIntegerAndLongState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import io.airlift.slice.SizeOf;
import java.math.BigInteger;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class BigIntegerAndLongStateFactory
implements AccumulatorStateFactory<BigIntegerAndLongState> {
    static final long BIG_INTEGER_APPROX_SIZE = (long)ClassLayout.parseClass(BigInteger.class).instanceSize() + SizeOf.sizeOf((int[])new int[0]) + 20L;

    public BigIntegerAndLongState createSingleState() {
        return new SingleBigIntegerAndLongState();
    }

    public Class<? extends BigIntegerAndLongState> getSingleStateClass() {
        return SingleBigIntegerAndLongState.class;
    }

    public BigIntegerAndLongState createGroupedState() {
        return new GroupedBigIntegerAndLongState();
    }

    public Class<? extends BigIntegerAndLongState> getGroupedStateClass() {
        return GroupedBigIntegerAndLongState.class;
    }

    public static class SingleBigIntegerAndLongState
    implements BigIntegerAndLongState {
        private BigInteger bigInteger;
        private long longValue;

        @Override
        public BigInteger getBigInteger() {
            return this.bigInteger;
        }

        @Override
        public void setBigInteger(BigInteger bigInteger) {
            this.bigInteger = bigInteger;
        }

        @Override
        public long getLong() {
            return this.longValue;
        }

        @Override
        public void setLong(long longValue) {
            this.longValue = longValue;
        }

        public long getEstimatedSize() {
            if (this.bigInteger == null) {
                return 8L;
            }
            return BIG_INTEGER_APPROX_SIZE + 8L;
        }
    }

    public static class GroupedBigIntegerAndLongState
    extends AbstractGroupedAccumulatorState
    implements BigIntegerAndLongState {
        private final ObjectBigArray<BigInteger> bigIntegers = new ObjectBigArray();
        private final LongBigArray longs = new LongBigArray();
        private long estimatedSizeOfBigIntegerObjects;

        public void ensureCapacity(long size) {
            this.bigIntegers.ensureCapacity(size);
            this.longs.ensureCapacity(size);
        }

        @Override
        public BigInteger getBigInteger() {
            return (BigInteger)this.bigIntegers.get(this.getGroupId());
        }

        @Override
        public void setBigInteger(BigInteger value) {
            Objects.requireNonNull(value, "value is null");
            if (this.getBigInteger() == null) {
                this.estimatedSizeOfBigIntegerObjects += BIG_INTEGER_APPROX_SIZE;
            }
            this.bigIntegers.set(this.getGroupId(), (Object)value);
        }

        @Override
        public long getLong() {
            return this.longs.get(this.getGroupId());
        }

        @Override
        public void setLong(long value) {
            this.longs.set(this.getGroupId(), value);
        }

        public long getEstimatedSize() {
            return this.bigIntegers.sizeOf() + this.longs.sizeOf() + this.estimatedSizeOfBigIntegerObjects + 8L;
        }
    }
}

