/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.RealType;

@AggregationFunction(value="avg")
public final class RealAverageAggregation {
    private RealAverageAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongAndDoubleState state, @SqlType(value="real") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)Float.intBitsToFloat((int)value));
    }

    @CombineFunction
    public static void combine(@AggregationState LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="real")
    public static void output(@AggregationState LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double average = state.getDouble() / (double)count;
            RealType.REAL.writeLong(out, (long)Float.floatToRawIntBits((float)average));
        }
    }
}

