/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.state.CovarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.DoubleType;

@AggregationFunction
public class DoubleCovarianceAggregation {
    private DoubleCovarianceAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState CovarianceState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCovarianceState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(@AggregationState CovarianceState state, @AggregationState CovarianceState otherState) {
        AggregationUtils.mergeCovarianceState(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="double")
    public static void covarSamp(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovarianceSample(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="double")
    public static void covarPop(@AggregationState CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = AggregationUtils.getCovariancePopulation(state);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

