/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.BigIntegerState;
import com.facebook.presto.operator.aggregation.state.BigIntegerStateFactory;
import com.facebook.presto.operator.aggregation.state.BigIntegerStateSerializer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public class DecimalSumAggregation
extends SqlAggregationFunction {
    public static final DecimalSumAggregation DECIMAL_SUM_AGGREGATION = new DecimalSumAggregation();
    private static final String NAME = "sum";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputShortDecimal", Type.class, BigIntegerState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "inputLongDecimal", Type.class, BigIntegerState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "outputLongDecimal", DecimalType.class, BigIntegerState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalSumAggregation.class, "combine", BigIntegerState.class, BigIntegerState.class);

    public DecimalSumAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"decimal(38,s)", (Set)ImmutableSet.of((Object)"s")), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))), FunctionKind.AGGREGATE);
    }

    @Override
    public String getDescription() {
        return "Calculates the sum over the input values";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type inputType = typeManager.getType((TypeSignature)Iterables.getOnlyElement(SignatureBinder.applyBoundVariables(this.getSignature().getArgumentTypes(), boundVariables)));
        Type outputType = typeManager.getType(SignatureBinder.applyBoundVariables(this.getSignature().getReturnType(), boundVariables));
        return DecimalSumAggregation.generateAggregation(inputType, outputType);
    }

    private static InternalAggregationFunction generateAggregation(Type inputType, Type outputType) {
        Preconditions.checkArgument((boolean)(inputType instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalSumAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)inputType);
        Class<BigIntegerState> stateInterface = BigIntegerState.class;
        BigIntegerStateSerializer stateSerializer = new BigIntegerStateSerializer();
        MethodHandle inputFunction = ((DecimalType)inputType).isShort() ? SHORT_DECIMAL_INPUT_FUNCTION : LONG_DECIMAL_INPUT_FUNCTION;
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, outputType.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList())), DecimalSumAggregation.createInputParameterMetadata(inputType), inputFunction.bindTo(inputType), COMBINE_FUNCTION, LONG_DECIMAL_OUTPUT_FUNCTION.bindTo(outputType), stateInterface, stateSerializer, new BigIntegerStateFactory(), outputType);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, intermediateType, outputType, true, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(Type type, BigIntegerState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(BigInteger.valueOf(type.getLong(block, position)), state);
    }

    public static void inputLongDecimal(Type type, BigIntegerState state, Block block, int position) {
        DecimalSumAggregation.accumulateValueInState(Decimals.decodeUnscaledValue((Slice)type.getSlice(block, position)), state);
    }

    private static void accumulateValueInState(BigInteger value, BigIntegerState state) {
        DecimalSumAggregation.initializeIfNeeded(state);
        state.setBigInteger(state.getBigInteger().add(value));
    }

    private static void initializeIfNeeded(BigIntegerState state) {
        if (state.getBigInteger() == null) {
            state.setBigInteger(BigInteger.valueOf(0L));
        }
    }

    public static void combine(BigIntegerState state, BigIntegerState otherState) {
        if (state.getBigInteger() == null) {
            state.setBigInteger(otherState.getBigInteger());
        } else {
            state.setBigInteger(state.getBigInteger().add(otherState.getBigInteger()));
        }
    }

    public static void outputLongDecimal(DecimalType type, BigIntegerState state, BlockBuilder out) {
        if (state.getBigInteger() == null) {
            out.appendNull();
        } else {
            BigDecimal value = new BigDecimal(state.getBigInteger(), type.getScale());
            Decimals.checkOverflow((BigInteger)state.getBigInteger());
            Decimals.writeBigDecimal((DecimalType)type, (BlockBuilder)out, (BigDecimal)value);
        }
    }
}

