/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.Page;
import java.util.Objects;
import java.util.stream.IntStream;

public class PartitionFunction {
    private final BucketFunction bucketFunction;
    private final int[] bucketToPartition;
    private final int partitionCount;

    public PartitionFunction(BucketFunction bucketFunction, int[] bucketToPartition) {
        this.bucketFunction = Objects.requireNonNull(bucketFunction, "bucketFunction is null");
        this.bucketToPartition = (int[])Objects.requireNonNull(bucketToPartition, "bucketToPartition is null").clone();
        this.partitionCount = IntStream.of(bucketToPartition).max().getAsInt() + 1;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getPartition(Page functionArguments, int position) {
        int bucket = this.bucketFunction.getBucket(functionArguments, position);
        return this.bucketToPartition[bucket];
    }
}

