/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;

public final class NestedLoopJoinPages {
    private final TaskContext taskContext;
    private final ImmutableList<Page> pages;
    private final DataSize estimatedSize;
    @GuardedBy(value="this")
    private boolean freed;

    NestedLoopJoinPages(List<Page> pages, DataSize estimatedSize, OperatorContext operatorContext) {
        Objects.requireNonNull(pages, "pages is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pages = ImmutableList.copyOf(pages);
        this.taskContext = operatorContext.getDriverContext().getPipelineContext().getTaskContext();
        this.estimatedSize = Objects.requireNonNull(estimatedSize, "estimatedSize is null");
        operatorContext.transferMemoryToTaskContext(estimatedSize.toBytes());
    }

    public List<Page> getPages() {
        return this.pages;
    }

    synchronized void freeMemory() {
        Preconditions.checkState((!this.freed ? 1 : 0) != 0, (Object)"Memory already freed");
        this.freed = true;
        this.taskContext.freeMemory(this.estimatedSize.toBytes());
    }
}

