/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.util.HashCollisionsEstimator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MultiChannelGroupByHash
implements GroupByHash {
    private static final float FILL_RATIO = 0.75f;
    private final List<Type> types;
    private final List<Type> hashTypes;
    private final int[] channels;
    private final PagesHashStrategy hashStrategy;
    private final List<ObjectArrayList<Block>> channelBuilders;
    private final Optional<Integer> inputHashChannel;
    private final HashGenerator hashGenerator;
    private final Optional<Integer> precomputedHashChannel;
    private final boolean processDictionary;
    private PageBuilder currentPageBuilder;
    private long completedPagesMemorySize;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private long[] groupAddressByHash;
    private int[] groupIdsByHash;
    private byte[] rawHashByHashPosition;
    private final LongBigArray groupAddressByGroupId;
    private int nextGroupId;
    private DictionaryLookBack dictionaryLookBack;
    private long hashCollisions;
    private double expectedHashCollisions;

    public MultiChannelGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler) {
        this.hashTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashTypes, "hashTypes is null"));
        Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        Preconditions.checkArgument((hashTypes.size() == hashChannels.length ? 1 : 0) != 0, (Object)"hashTypes and hashChannels have different sizes");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.inputHashChannel = Objects.requireNonNull(inputHashChannel, "inputHashChannel is null");
        this.types = inputHashChannel.isPresent() ? ImmutableList.copyOf((Iterable)Iterables.concat(hashTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))) : this.hashTypes;
        this.channels = (int[])Objects.requireNonNull(hashChannels, "hashChannels is null").clone();
        this.hashGenerator = inputHashChannel.isPresent() ? new PrecomputedHashGenerator(inputHashChannel.get()) : new InterpretedHashGenerator(this.hashTypes, hashChannels);
        this.processDictionary = processDictionary;
        ImmutableList.Builder outputChannels = ImmutableList.builder();
        ImmutableList.Builder channelBuilders = ImmutableList.builder();
        for (int i = 0; i < hashChannels.length; ++i) {
            outputChannels.add((Object)i);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        }
        if (inputHashChannel.isPresent()) {
            this.precomputedHashChannel = Optional.of(hashChannels.length);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        } else {
            this.precomputedHashChannel = Optional.empty();
        }
        this.channelBuilders = channelBuilders.build();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory(this.types, (List<Integer>)outputChannels.build());
        this.hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy(this.channelBuilders, this.precomputedHashChannel);
        this.startNewPage();
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.groupAddressByHash = new long[this.hashCapacity];
        Arrays.fill(this.groupAddressByHash, -1L);
        this.rawHashByHashPosition = new byte[this.hashCapacity];
        this.groupIdsByHash = new int[this.hashCapacity];
        this.groupAddressByGroupId = new LongBigArray();
        this.groupAddressByGroupId.ensureCapacity((long)this.maxFill);
    }

    @Override
    public long getRawHash(int groupId) {
        long address = this.groupAddressByGroupId.get((long)groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        return this.hashStrategy.hashPosition(blockIndex, position);
    }

    @Override
    public long getEstimatedSize() {
        return SizeOf.sizeOf((Object[])this.channelBuilders.get(0).elements()) * (long)this.channelBuilders.size() + this.completedPagesMemorySize + this.currentPageBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((long[])this.groupAddressByHash) + SizeOf.sizeOf((int[])this.groupIdsByHash) + this.groupAddressByGroupId.sizeOf() + SizeOf.sizeOf((byte[])this.rawHashByHashPosition);
    }

    @Override
    public long getHashCollisions() {
        return this.hashCollisions;
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.expectedHashCollisions + HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public int getGroupCount() {
        return this.nextGroupId;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        long address = this.groupAddressByGroupId.get((long)groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        this.hashStrategy.appendTo(blockIndex, position, pageBuilder, outputChannelOffset);
    }

    @Override
    public void addPage(Page page) {
        if (this.canProcessDictionary(page)) {
            this.addDictionaryPage(page);
            return;
        }
        int positionCount = page.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            this.putIfAbsent(position, page);
        }
    }

    @Override
    public GroupByIdBlock getGroupIds(Page page) {
        int positionCount = page.getPositionCount();
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(positionCount);
        if (this.canProcessDictionary(page)) {
            Block groupIds = this.processDictionary(page);
            return new GroupByIdBlock(this.nextGroupId, groupIds);
        }
        for (int position = 0; position < positionCount; ++position) {
            int groupId = this.putIfAbsent(position, page);
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        return new GroupByIdBlock(this.nextGroupId, blockBuilder.build());
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        long rawHash = this.hashStrategy.hashRow(position, page);
        int hashPosition = (int)MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        while (this.groupAddressByHash[hashPosition] != -1L) {
            if (this.positionEqualsCurrentRow(this.groupAddressByHash[hashPosition], hashPosition, position, page, (byte)rawHash, hashChannels)) {
                return true;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        return false;
    }

    @Override
    public int putIfAbsent(int position, Page page) {
        long rawHash = this.hashGenerator.hashPosition(position, page);
        return this.putIfAbsent(position, page, rawHash);
    }

    private int putIfAbsent(int position, Page page, long rawHash) {
        int hashPosition = (int)MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        int groupId = -1;
        while (this.groupAddressByHash[hashPosition] != -1L) {
            if (this.positionEqualsCurrentRow(this.groupAddressByHash[hashPosition], hashPosition, position, page, (byte)rawHash, this.channels)) {
                groupId = this.groupIdsByHash[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
            ++this.hashCollisions;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, position, page, rawHash);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, int position, Page page, long rawHash) {
        for (int i = 0; i < this.channels.length; ++i) {
            int hashChannel = this.channels[i];
            Type type = this.types.get(i);
            type.appendTo(page.getBlock(hashChannel), position, this.currentPageBuilder.getBlockBuilder(i));
        }
        if (this.precomputedHashChannel.isPresent()) {
            BigintType.BIGINT.writeLong(this.currentPageBuilder.getBlockBuilder(this.precomputedHashChannel.get().intValue()), rawHash);
        }
        this.currentPageBuilder.declarePosition();
        int pageIndex = this.channelBuilders.get(0).size() - 1;
        int pagePosition = this.currentPageBuilder.getPositionCount() - 1;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pagePosition);
        int groupId = this.nextGroupId++;
        this.groupAddressByHash[hashPosition] = address;
        this.rawHashByHashPosition[hashPosition] = (byte)rawHash;
        this.groupIdsByHash[hashPosition] = groupId;
        this.groupAddressByGroupId.set((long)groupId, address);
        if (this.currentPageBuilder.isFull()) {
            this.startNewPage();
        }
        if (this.nextGroupId >= this.maxFill) {
            this.rehash();
        }
        return groupId;
    }

    private void startNewPage() {
        if (this.currentPageBuilder != null) {
            this.completedPagesMemorySize += this.currentPageBuilder.getRetainedSizeInBytes();
        }
        this.currentPageBuilder = new PageBuilder(this.types);
        for (int i = 0; i < this.types.size(); ++i) {
            this.channelBuilders.get(i).add((Object)this.currentPageBuilder.getBlockBuilder(i));
        }
    }

    private void rehash() {
        this.expectedHashCollisions += HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = (int)newCapacityLong;
        int newMask = newCapacity - 1;
        long[] newKey = new long[newCapacity];
        byte[] rawHashes = new byte[newCapacity];
        Arrays.fill(newKey, -1L);
        int[] newValue = new int[newCapacity];
        int oldIndex = 0;
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            while (this.groupAddressByHash[oldIndex] == -1L) {
                ++oldIndex;
            }
            long address = this.groupAddressByHash[oldIndex];
            long rawHash = this.hashPosition(address);
            int pos = (int)MultiChannelGroupByHash.getHashPosition(rawHash, newMask);
            while (newKey[pos] != -1L) {
                pos = pos + 1 & newMask;
                ++this.hashCollisions;
            }
            newKey[pos] = address;
            rawHashes[pos] = (byte)rawHash;
            newValue[pos] = this.groupIdsByHash[oldIndex];
            ++oldIndex;
        }
        this.mask = newMask;
        this.hashCapacity = newCapacity;
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(newCapacity);
        this.groupAddressByHash = newKey;
        this.rawHashByHashPosition = rawHashes;
        this.groupIdsByHash = newValue;
        this.groupAddressByGroupId.ensureCapacity((long)this.maxFill);
    }

    private long hashPosition(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        int position = SyntheticAddress.decodePosition(sliceAddress);
        if (this.precomputedHashChannel.isPresent()) {
            return this.getRawHash(sliceIndex, position);
        }
        return this.hashStrategy.hashPosition(sliceIndex, position);
    }

    private long getRawHash(int sliceIndex, int position) {
        return ((Block)this.channelBuilders.get(this.precomputedHashChannel.get()).get(sliceIndex)).getLong(position, 0);
    }

    private boolean positionEqualsCurrentRow(long address, int hashPosition, int position, Page page, byte rawHash, int[] hashChannels) {
        if (this.rawHashByHashPosition[hashPosition] != rawHash) {
            return false;
        }
        return this.hashStrategy.positionEqualsRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, page, hashChannels);
    }

    private static long getHashPosition(long rawHash, int mask) {
        return HashCommon.murmurHash3((long)rawHash) & (long)mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private void addDictionaryPage(Page page) {
        Verify.verify((boolean)this.canProcessDictionary(page), (String)"invalid call to addDictionaryPage", (Object[])new Object[0]);
        DictionaryBlock dictionaryBlock = (DictionaryBlock)page.getBlock(this.channels[0]);
        this.updateDictionaryLookBack(dictionaryBlock.getDictionary());
        Page dictionaryPage = this.createPageWithExtractedDictionary(page);
        for (int i = 0; i < page.getPositionCount(); ++i) {
            int positionInDictionary = dictionaryBlock.getId(i);
            this.getGroupId(this.hashGenerator, dictionaryPage, positionInDictionary);
        }
    }

    private void updateDictionaryLookBack(Block dictionary) {
        if (this.dictionaryLookBack == null || this.dictionaryLookBack.getDictionary() != dictionary) {
            this.dictionaryLookBack = new DictionaryLookBack(dictionary);
        }
    }

    private Block processDictionary(Page page) {
        Verify.verify((boolean)this.canProcessDictionary(page), (String)"invalid call to processDictionary", (Object[])new Object[0]);
        DictionaryBlock dictionaryBlock = (DictionaryBlock)page.getBlock(this.channels[0]);
        this.updateDictionaryLookBack(dictionaryBlock.getDictionary());
        Page dictionaryPage = this.createPageWithExtractedDictionary(page);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(page.getPositionCount());
        for (int i = 0; i < page.getPositionCount(); ++i) {
            int positionInDictionary = dictionaryBlock.getId(i);
            int groupId = this.getGroupId(this.hashGenerator, dictionaryPage, positionInDictionary);
            BigintType.BIGINT.writeLong(blockBuilder, (long)groupId);
        }
        Verify.verify((blockBuilder.getPositionCount() == page.getPositionCount() ? 1 : 0) != 0, (String)"invalid position count", (Object[])new Object[0]);
        return blockBuilder.build();
    }

    private Page createPageWithExtractedDictionary(Page page) {
        Block dictionary;
        Block[] blocks = new Block[page.getChannelCount()];
        blocks[this.channels[0]] = dictionary = ((DictionaryBlock)page.getBlock(this.channels[0])).getDictionary();
        if (this.inputHashChannel.isPresent()) {
            blocks[this.inputHashChannel.get().intValue()] = ((DictionaryBlock)page.getBlock(this.inputHashChannel.get().intValue())).getDictionary();
        }
        return new Page(dictionary.getPositionCount(), blocks);
    }

    private boolean canProcessDictionary(Page page) {
        boolean processDictionary;
        boolean bl = processDictionary = this.processDictionary && this.channels.length == 1 && page.getBlock(this.channels[0]) instanceof DictionaryBlock;
        if (processDictionary && this.inputHashChannel.isPresent()) {
            Block inputHashBlock = page.getBlock(this.inputHashChannel.get().intValue());
            DictionaryBlock inputDataBlock = (DictionaryBlock)page.getBlock(this.channels[0]);
            Verify.verify((boolean)(inputHashBlock instanceof DictionaryBlock), (String)"data channel is dictionary encoded but hash channel is not", (Object[])new Object[0]);
            Verify.verify((boolean)((DictionaryBlock)inputHashBlock).getDictionarySourceId().equals((Object)inputDataBlock.getDictionarySourceId()), (String)"dictionarySourceIds of data block and hash block do not match", (Object[])new Object[0]);
        }
        return processDictionary;
    }

    private int getGroupId(HashGenerator hashGenerator, Page page, int positionInDictionary) {
        if (this.dictionaryLookBack.isProcessed(positionInDictionary)) {
            return this.dictionaryLookBack.getGroupId(positionInDictionary);
        }
        int groupId = this.putIfAbsent(positionInDictionary, page, hashGenerator.hashPosition(positionInDictionary, page));
        this.dictionaryLookBack.setProcessed(positionInDictionary, groupId);
        return groupId;
    }

    private static final class DictionaryLookBack {
        private final Block dictionary;
        private final int[] processed;

        public DictionaryLookBack(Block dictionary) {
            this.dictionary = dictionary;
            this.processed = new int[dictionary.getPositionCount()];
            Arrays.fill(this.processed, -1);
        }

        public Block getDictionary() {
            return this.dictionary;
        }

        public int getGroupId(int position) {
            return this.processed[position];
        }

        public boolean isProcessed(int position) {
            return this.processed[position] != -1;
        }

        public void setProcessed(int position, int groupId) {
            this.processed[position] = groupId;
        }
    }
}

